/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.web.controller;

import com.jxdinfo.hussar.platform.core.utils.lang.MultiLangUtil;
import com.jxdinfo.hussar.support.job.core.enums.InstanceStatus;
import com.jxdinfo.hussar.support.job.core.request.http.SaveJobInfoRequest;
import com.jxdinfo.hussar.support.job.core.response.InstanceInfoDTO;
import com.jxdinfo.hussar.support.job.core.response.JobInfoDTO;
import com.jxdinfo.hussar.support.job.core.response.ResultDTO;
import com.jxdinfo.hussar.support.job.dispatch.core.instance.InstanceService;
import com.jxdinfo.hussar.support.job.dispatch.core.service.AppInfoService;
import com.jxdinfo.hussar.support.job.dispatch.core.service.CacheService;
import com.jxdinfo.hussar.support.job.dispatch.core.service.JobService;
import java.text.ParseException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openApi"})
public class OpenAPIController {
    @Resource
    private AppInfoService appInfoService;
    @Resource
    private JobService jobService;
    @Resource
    private InstanceService instanceService;
    @Resource
    private CacheService cacheService;

    @PostMapping(value={"/assert"})
    public ResultDTO<Long> assertAppName(String appName, @RequestParam(required=false) String password) {
        return ResultDTO.success((Object)this.appInfoService.assertApp(appName, password));
    }

    @PostMapping(value={"/saveJob"})
    public ResultDTO<Long> saveJob(@RequestBody SaveJobInfoRequest request) throws ParseException {
        if (request.getId() != null) {
            this.checkJobIdValid(request.getId(), request.getAppId());
        }
        return ResultDTO.success((Object)this.jobService.saveJob(request));
    }

    @PostMapping(value={"/copyJob"})
    public ResultDTO<Long> copyJob(Long jobId) {
        return ResultDTO.success((Object)this.jobService.copyJob(jobId).getId());
    }

    @PostMapping(value={"/fetchJob"})
    public ResultDTO<JobInfoDTO> fetchJob(Long jobId, Long appId) {
        this.checkJobIdValid(jobId, appId);
        return ResultDTO.success((Object)this.jobService.fetchJob(jobId));
    }

    @PostMapping(value={"/fetchAllJob"})
    public ResultDTO<List<JobInfoDTO>> fetchAllJob(Long appId) {
        return ResultDTO.success((Object)this.jobService.fetchAllJob(appId));
    }

    @GetMapping(value={"/queryJob"})
    public ResultDTO<List<JobInfoDTO>> queryJob(HttpServletRequest request) {
        return ResultDTO.success((Object)this.jobService.queryJob(request.getParameterMap()));
    }

    @PostMapping(value={"/deleteJob"})
    public ResultDTO<Void> deleteJob(Long jobId, Long appId) {
        this.checkJobIdValid(jobId, appId);
        this.jobService.deleteJob(jobId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/disableJob"})
    public ResultDTO<Void> disableJob(Long jobId, Long appId) {
        this.checkJobIdValid(jobId, appId);
        this.jobService.disableJob(jobId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/enableJob"})
    public ResultDTO<Void> enableJob(Long jobId, Long appId) throws ParseException {
        this.checkJobIdValid(jobId, appId);
        this.jobService.enableJob(jobId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/runJob"})
    public ResultDTO<Long> runJob(Long appId, Long jobId, @RequestParam(required=false) String instanceParams, @RequestParam(required=false) Long delay) {
        this.checkJobIdValid(jobId, appId);
        return ResultDTO.success((Object)this.jobService.runJob(appId, jobId, instanceParams, delay));
    }

    @PostMapping(value={"/stopInstance"})
    public ResultDTO<Void> stopInstance(Long instanceId, Long appId) {
        this.checkInstanceIdValid(instanceId, appId);
        this.instanceService.stopInstance(appId, instanceId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/cancelInstance"})
    public ResultDTO<Void> cancelInstance(Long instanceId, Long appId) {
        this.checkInstanceIdValid(instanceId, appId);
        this.instanceService.cancelInstance(instanceId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/retryInstance"})
    public ResultDTO<Void> retryInstance(Long instanceId, Long appId) {
        this.checkInstanceIdValid(instanceId, appId);
        this.instanceService.retryInstance(appId, instanceId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/fetchInstanceStatus"})
    public ResultDTO<Integer> fetchInstanceStatus(Long instanceId) {
        InstanceStatus instanceStatus = this.instanceService.getInstanceStatus(instanceId);
        return ResultDTO.success((Object)instanceStatus.getV());
    }

    @PostMapping(value={"/fetchInstanceInfo"})
    public ResultDTO<InstanceInfoDTO> fetchInstanceInfo(Long instanceId) {
        return ResultDTO.success((Object)this.instanceService.getInstanceInfo(instanceId));
    }

    @GetMapping(value={"/queryInstance"})
    public ResultDTO<List<InstanceInfoDTO>> queryInstance(HttpServletRequest request) {
        return ResultDTO.success((Object)this.instanceService.queryInstanceInfo(request.getParameterMap()));
    }

    private void checkInstanceIdValid(Long instanceId, Long appId) {
        Long realAppId = this.cacheService.getAppIdByInstanceId(instanceId);
        if (realAppId == null) {
            throw new IllegalArgumentException(MultiLangUtil.getTranslateName((String)"job::cannot.find.instance.by.id") + instanceId);
        }
        if (appId.equals(realAppId)) {
            return;
        }
        throw new IllegalArgumentException(MultiLangUtil.getTranslateName((String)"job::instance.not.belong.to.app") + appId);
    }

    private void checkJobIdValid(Long jobId, Long appId) {
        Long realAppId = this.cacheService.getAppIdByJobId(jobId);
        if (realAppId == null) {
            throw new IllegalArgumentException(MultiLangUtil.getTranslateName((String)"job::cannot.find.job.by.id") + jobId);
        }
        if (!appId.equals(realAppId)) {
            throw new IllegalArgumentException(MultiLangUtil.getTranslateName((String)"job::instance.not.belong.to.app") + appId);
        }
    }
}

