/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.remote.transport;

import com.google.common.collect.Maps;
import com.jxdinfo.hussar.support.job.core.JobSerializable;
import com.jxdinfo.hussar.support.job.core.enums.Protocol;
import com.jxdinfo.hussar.support.job.core.response.AskResponse;
import com.jxdinfo.hussar.support.job.dispatch.remote.transport.Transporter;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransportService {
    private static final Logger log = LoggerFactory.getLogger(TransportService.class);
    private static final Map<Protocol, String> protocol2Address = Maps.newHashMap();
    private static final Map<Protocol, Transporter> protocol2Transporter = Maps.newConcurrentMap();

    @Autowired
    public TransportService(List<Transporter> transporters) {
        transporters.forEach(t -> {
            log.info("[TransportService] Transporter[protocol:{},address:{}] registration successful!", (Object)t.getProtocol(), (Object)t.getAddress());
            protocol2Transporter.put(t.getProtocol(), (Transporter)t);
            protocol2Address.put(t.getProtocol(), t.getAddress());
        });
    }

    public void tell(Protocol protocol, String address, JobSerializable object) {
        this.getTransporter(protocol).tell(address, object);
    }

    public AskResponse ask(Protocol protocol, String address, JobSerializable object) throws Exception {
        return this.getTransporter(protocol).ask(address, object);
    }

    public Transporter getTransporter(Protocol protocol) {
        Transporter transporter = protocol2Transporter.get(protocol);
        if (transporter == null) {
            log.error("[TransportService] can't find transporter by protocol[{}], this is a bug!", (Object)protocol);
            throw new UnknownProtocolException("can't find transporter by protocol: " + protocol);
        }
        return transporter;
    }

    public static Map<Protocol, String> getAllAddress() {
        return protocol2Address;
    }

    public static Map<Protocol, Transporter> getProtocol2Transporter() {
        return protocol2Transporter;
    }

    public static class UnknownProtocolException
    extends RuntimeException {
        public UnknownProtocolException(String message) {
            super(message);
        }
    }
}

