/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.remote.server;

import akka.actor.AbstractActor;
import com.jxdinfo.hussar.support.job.core.response.AskResponse;
import com.jxdinfo.hussar.support.job.core.serialize.JsonUtils;
import com.jxdinfo.hussar.support.job.dispatch.remote.server.election.Ping;
import com.jxdinfo.hussar.support.job.dispatch.remote.server.redirector.RemoteProcessReq;
import com.jxdinfo.hussar.support.job.dispatch.remote.server.redirector.RemoteRequestProcessor;
import com.jxdinfo.hussar.support.job.dispatch.remote.transport.TransportService;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FriendRequestHandler
extends AbstractActor {
    private static Logger log = LoggerFactory.getLogger(FriendRequestHandler.class);

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(Ping.class, this::onReceivePing).match(RemoteProcessReq.class, this::onReceiveRemoteProcessReq).matchAny(obj -> log.warn("[FriendActor] receive unknown request: {}.", obj)).build();
    }

    private void onReceivePing(Ping ping) {
        this.getSender().tell((Object)AskResponse.succeed(TransportService.getAllAddress()), this.getSelf());
    }

    private void onReceiveRemoteProcessReq(RemoteProcessReq req) {
        AskResponse response = new AskResponse();
        response.setSuccess(true);
        try {
            response.setData(JsonUtils.toBytes((Object)RemoteRequestProcessor.processRemoteRequest(req)));
        }
        catch (Throwable t) {
            log.error("[FriendActor] process remote request[{}] failed!", (Object)req, (Object)t);
            response.setSuccess(false);
            response.setMessage(ExceptionUtils.getMessage((Throwable)t));
        }
        this.getSender().tell((Object)response, this.getSelf());
    }
}

