/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.extension.defaultimpl.alram.impl;

import com.jxdinfo.hussar.support.job.dispatch.dao.entity.JobUserInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.extension.Alarmable;
import com.jxdinfo.hussar.support.job.dispatch.extension.defaultimpl.alram.module.Alarm;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class MailAlarmService
implements Alarmable {
    private static final Logger log = LoggerFactory.getLogger(MailAlarmService.class);
    @Resource
    private Environment environment;
    private JavaMailSender javaMailSender;
    private String from;
    private static final String FROM_KEY = "spring.mail.username";

    @Override
    public void onFailed(Alarm alarm, List<JobUserInfoEntity> targetUserList) {
        this.initFrom();
        if (CollectionUtils.isEmpty(targetUserList) || this.javaMailSender == null || StringUtils.isEmpty((Object)this.from)) {
            return;
        }
        SimpleMailMessage sm = new SimpleMailMessage();
        try {
            sm.setFrom(this.from);
            sm.setTo((String[])targetUserList.stream().map(JobUserInfoEntity::getEmail).filter(Objects::nonNull).toArray(String[]::new));
            sm.setSubject(alarm.fetchTitle());
            sm.setText(alarm.fetchContent());
            this.javaMailSender.send(sm);
        }
        catch (Exception e) {
            log.warn("[MailAlarmService] send mail failed, reason is {}", (Object)e.getMessage());
        }
    }

    @Autowired(required=false)
    public void setJavaMailSender(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    private void initFrom() {
        if (StringUtils.isEmpty((Object)this.from)) {
            this.from = this.environment.getProperty(FROM_KEY);
        }
    }
}

