/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.websocket.support.session;

import com.jxdinfo.hussar.support.websocket.support.session.WebSocketSessionManager;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.ConcurrentWebSocketSessionDecorator;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;

public class WebSocketSessionHandlerDecorator
extends WebSocketHandlerDecorator {
    private static final Integer SEND_TIME_LIMIT = 5000;
    private static final Integer BUFFER_SIZE_LIMIT = 102400;
    private final WebSocketSessionManager sessionManager;

    public WebSocketSessionHandlerDecorator(WebSocketHandler delegate, WebSocketSessionManager sessionManager) {
        super(delegate);
        this.sessionManager = sessionManager;
    }

    public void afterConnectionEstablished(WebSocketSession session) {
        session = new ConcurrentWebSocketSessionDecorator(session, SEND_TIME_LIMIT.intValue(), BUFFER_SIZE_LIMIT.intValue());
        this.sessionManager.addSession(session);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) {
        this.sessionManager.removeSession(session);
    }
}

