/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.websocket.support.session;

import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.websocket.support.session.WebSocketSessionManager;
import com.jxdinfo.hussar.support.websocket.support.util.WebSocketFrameworkUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.web.socket.WebSocketSession;

public class WebSocketSessionManagerImpl
implements WebSocketSessionManager {
    private final ConcurrentMap<String, WebSocketSession> idSessions = new ConcurrentHashMap<String, WebSocketSession>();
    private final ConcurrentMap<Long, CopyOnWriteArrayList<WebSocketSession>> userSessions = new ConcurrentHashMap<Long, CopyOnWriteArrayList<WebSocketSession>>();

    @Override
    public void addSession(WebSocketSession session) {
        this.idSessions.put(session.getId(), session);
        UserDetails user = WebSocketFrameworkUtils.getLoginUser(session);
        if (user == null) {
            return;
        }
        CopyOnWriteArrayList<WebSocketSession> userSessionsList = (CopyOnWriteArrayList<WebSocketSession>)this.userSessions.get(user.getUserId());
        if (HussarUtils.isEmpty((Object)userSessionsList)) {
            userSessionsList = new CopyOnWriteArrayList<WebSocketSession>();
        }
        userSessionsList.add(session);
        this.userSessions.put(user.getUserId(), userSessionsList);
    }

    @Override
    public void removeSession(WebSocketSession session) {
        UserDetails user;
        if (HussarUtils.isEmpty(this.idSessions)) {
            return;
        }
        WebSocketSession webSocketSession = (WebSocketSession)this.idSessions.get(session.getId());
        if (HussarUtils.isNotEmpty((Object)webSocketSession)) {
            this.idSessions.remove(session.getId(), webSocketSession);
        }
        if ((user = WebSocketFrameworkUtils.getLoginUser(session)) == null) {
            return;
        }
        CopyOnWriteArrayList userSessionsList = (CopyOnWriteArrayList)this.userSessions.get(user.getUserId());
        if (userSessionsList == null) {
            return;
        }
        userSessionsList.removeIf(session0 -> session0.getId().equals(session.getId()));
    }

    @Override
    public WebSocketSession getSession(String id) {
        return (WebSocketSession)this.idSessions.get(id);
    }

    @Override
    public Collection<WebSocketSession> getSessionList(Long userId) {
        CopyOnWriteArrayList userSessionsList = (CopyOnWriteArrayList)this.userSessions.get(userId);
        return HussarUtils.isNotEmpty((Object)userSessionsList) ? new ArrayList<WebSocketSession>(userSessionsList) : new ArrayList();
    }

    @Override
    public Collection<WebSocketSession> getSessionList() {
        if (HussarUtils.isEmpty(this.idSessions)) {
            return new ArrayList<WebSocketSession>();
        }
        return HussarUtils.isNotEmpty(this.idSessions.values()) ? new ArrayList(this.idSessions.values()) : new ArrayList();
    }
}

