/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.websocket.support.sender;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.websocket.support.message.JsonWebSocketMessage;
import com.jxdinfo.hussar.support.websocket.support.sender.WebSocketMessageSender;
import com.jxdinfo.hussar.support.websocket.support.session.WebSocketSessionManager;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public abstract class AbstractWebSocketMessageSender
implements WebSocketMessageSender {
    private static Logger logger = LoggerFactory.getLogger(AbstractWebSocketMessageSender.class);
    private final WebSocketSessionManager sessionManager;

    public AbstractWebSocketMessageSender() {
        this.sessionManager = null;
    }

    public AbstractWebSocketMessageSender(WebSocketSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public void send(Long userId, String messageType, String messageContent) {
        this.send(null, userId, messageType, messageContent);
    }

    @Override
    public void send(String sessionId, String messageType, String messageContent) {
        this.send(sessionId, null, messageType, messageContent);
    }

    @Override
    public void sendGroup(String messageType, String messageContent) {
        this.send(null, null, messageType, messageContent);
    }

    @Override
    public void send(String messageType, String messageContent) {
        this.send(null, null, messageType, messageContent);
    }

    public void send(String sessionId, Long userId, String messageType, String messageContent) {
        List<Object> sessions = Collections.emptyList();
        if (HussarUtils.isNotEmpty((Object)sessionId)) {
            WebSocketSession session = this.sessionManager.getSession(sessionId);
            if (HussarUtils.isNotEmpty((Object)session)) {
                sessions = Collections.singletonList(session);
            }
        } else {
            sessions = HussarUtils.isNotEmpty((Object)userId) ? (List)this.sessionManager.getSessionList(userId) : (List<WebSocketSession>)this.sessionManager.getSessionList();
        }
        if (HussarUtils.isEmpty((Object)sessions)) {
            logger.info("[send][sessionId({}) userId({}) messageType({}) messageContent({}) \u672a\u5339\u914d\u5230\u4f1a\u8bdd]", new Object[]{sessionId, userId, messageType, messageContent});
        }
        this.doSend(sessions, messageType, messageContent);
    }

    public void doSend(Collection<WebSocketSession> sessions, String messageType, String messageContent) {
        JsonWebSocketMessage message = new JsonWebSocketMessage();
        message.setType(messageType);
        message.setContent(messageContent);
        String payload = JsonUtil.toJson((Object)message);
        sessions.forEach(session -> {
            if (session == null) {
                logger.error("[doSend][session \u4e3a\u7a7a, message({})]", (Object)message);
                return;
            }
            if (!session.isOpen()) {
                logger.error("[doSend][session({}) \u5df2\u5173\u95ed, message({})]", (Object)session.getId(), (Object)message);
                return;
            }
            try {
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)payload));
                logger.info("[doSend][session({}) \u53d1\u9001\u6d88\u606f\u6210\u529f\uff0cmessage({})]", (Object)session.getId(), (Object)message);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                logger.error("[doSend][session({}) \u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0cmessage({})]", new Object[]{session.getId(), message, ex});
            }
        });
    }
}

