/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.thread.config;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.thread.config.HussarTaskExecutorConfiguration;
import com.jxdinfo.hussar.support.thread.config.HussarTpProperties;
import com.jxdinfo.hussar.support.thread.core.RejectedExecutionHandlerEnum;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Configuration
@EnableAsync
@ConditionalOnMissingBean(value={AsyncConfigurer.class})
@Import(value={HussarTpProperties.class, HussarTaskExecutorConfiguration.class})
public class HussarThreadPoolConfiguration
implements AsyncConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(HussarThreadPoolConfiguration.class);
    @Autowired
    private HussarTpProperties hussarTpProperties;
    volatile ThreadPoolTaskExecutor taskExecutor = null;
    private RequestAttributes context;

    @Bean(name={"hussarAsyncPoolTaskExecutor"})
    @Primary
    @Scope(value="singleton")
    public ThreadPoolTaskExecutor hussarThreadPoolTaskExecutor() {
        HussarThreadPoolTaskExecutor taskExecutor = new HussarThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(this.hussarTpProperties.getCorePoolSize());
        taskExecutor.setMaxPoolSize(this.hussarTpProperties.getMaxPoolSize());
        taskExecutor.setQueueCapacity(this.hussarTpProperties.getQueueCapacity());
        taskExecutor.setKeepAliveSeconds(60);
        RejectedExecutionHandlerEnum handler = this.hussarTpProperties.getRejectedExecutionHandler();
        if (handler == null) {
            taskExecutor.setRejectedExecutionHandler(RejectedExecutionHandlerEnum.instantiationHandler(null));
        } else {
            taskExecutor.setRejectedExecutionHandler(RejectedExecutionHandlerEnum.instantiationHandler(handler.getKey()));
        }
        taskExecutor.setThreadNamePrefix("hussar-async-");
        taskExecutor.initialize();
        return taskExecutor;
    }

    public void beforeSubmit(Map<String, Object> parameters) {
        if (HussarUtils.isEmpty((Object)this.context)) {
            this.context = RequestContextHolder.getRequestAttributes();
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
        }
    }

    public void beforeExecute(Map<String, Object> parameters) {
        if (HussarUtils.isNotEmpty((Object)this.context)) {
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
        }
    }

    public void afterExecute(Map<String, Object> parameters) {
        this.context = null;
    }

    public Executor getAsyncExecutor() {
        return this.hussarThreadPoolTaskExecutor();
    }

    private class HussarThreadPoolTaskExecutor
    extends ThreadPoolTaskExecutor {
        private HussarThreadPoolTaskExecutor() {
        }

        public <T> Future<T> submit(Callable<T> task) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            HussarThreadPoolConfiguration.this.beforeSubmit(parameters);
            Callable<Object> newTask = () -> {
                HussarThreadPoolConfiguration.this.beforeExecute(parameters);
                Object call = null;
                try {
                    call = task.call();
                    HussarThreadPoolConfiguration.this.afterExecute(parameters);
                }
                catch (Exception e) {
                    HussarThreadPoolConfiguration.this.afterExecute(parameters);
                    throw e;
                }
                return call;
            };
            return super.submit(newTask);
        }

        public Future<?> submit(Runnable task) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            HussarThreadPoolConfiguration.this.beforeSubmit(parameters);
            Runnable newTask = () -> {
                HussarThreadPoolConfiguration.this.beforeExecute(parameters);
                try {
                    task.run();
                    HussarThreadPoolConfiguration.this.afterExecute(parameters);
                }
                catch (Throwable e) {
                    HussarThreadPoolConfiguration.this.afterExecute(parameters);
                    throw e;
                }
            };
            return super.submit(newTask);
        }

        public void execute(Runnable task) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            HussarThreadPoolConfiguration.this.beforeSubmit(parameters);
            Runnable newTask = () -> {
                HussarThreadPoolConfiguration.this.beforeExecute(parameters);
                try {
                    task.run();
                    HussarThreadPoolConfiguration.this.afterExecute(parameters);
                }
                catch (Throwable e) {
                    HussarThreadPoolConfiguration.this.afterExecute(parameters);
                    throw e;
                }
            };
            super.execute(newTask);
        }
    }
}

