/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.thread.support.executor;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class HussarThreadPoolTaskScheduler
extends ThreadPoolTaskScheduler {
    private TaskDecorator taskDecorator;

    protected ScheduledExecutorService createExecutor(int poolSize, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        if (HussarUtils.isNotEmpty((Object)this.taskDecorator)) {
            return new ScheduledThreadPoolExecutor(poolSize, threadFactory, rejectedExecutionHandler){

                @Override
                public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                    Runnable decorated = HussarThreadPoolTaskScheduler.this.taskDecorator.decorate(command);
                    return super.schedule(decorated, delay, unit);
                }

                @Override
                public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
                    Runnable decorated = HussarThreadPoolTaskScheduler.this.taskDecorator.decorate(command);
                    return super.scheduleAtFixedRate(decorated, initialDelay, period, unit);
                }

                @Override
                public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
                    Runnable decorated = HussarThreadPoolTaskScheduler.this.taskDecorator.decorate(command);
                    return super.scheduleWithFixedDelay(decorated, initialDelay, delay, unit);
                }
            };
        }
        return super.createExecutor(poolSize, threadFactory, rejectedExecutionHandler);
    }

    public TaskDecorator getTaskDecorator() {
        return this.taskDecorator;
    }

    public void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }
}

