/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.thread.support.executor;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.thread.core.RejectedExecutionHandlerEnum;
import com.jxdinfo.hussar.support.thread.support.custom.HussarSyncCustomAction;
import com.jxdinfo.hussar.support.thread.support.executor.HussarThreadPoolTaskScheduler;
import com.jxdinfo.hussar.support.thread.support.taskdecorator.HussarTaskDecorator;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;

public class HussarTaskExecutor
implements DisposableBean {
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;
    private final HussarSyncCustomAction syncCustomAction;
    private final Map<Object, HussarThreadPoolTaskScheduler> SCHEDULER_MAP = new ConcurrentHashMap<Object, HussarThreadPoolTaskScheduler>(16);
    private final Map<Object, ThreadPoolTaskExecutor> EXECUTOR_MAP = new ConcurrentHashMap<Object, ThreadPoolTaskExecutor>(16);

    public HussarTaskExecutor(ThreadPoolTaskExecutor threadPoolTaskExecutor, ThreadPoolTaskScheduler threadPoolTaskScheduler, HussarSyncCustomAction syncCustomAction) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
        this.threadPoolTaskScheduler = threadPoolTaskScheduler;
        this.syncCustomAction = syncCustomAction;
    }

    public void execute(Runnable task) {
        this.threadPoolTaskExecutor.execute(task);
    }

    public void submit(Runnable task) {
        this.threadPoolTaskExecutor.submit(task);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.threadPoolTaskExecutor.submit(task);
    }

    public void execute(int corePoolSize, int maxPoolSize, int queueCapacity, RejectedExecutionHandler handler, Runnable task) {
        ThreadPoolTaskExecutor executor = this.createThreadPoolTaskExecutor(corePoolSize, maxPoolSize, queueCapacity, handler);
        this.execute(executor, task);
    }

    public void execute(ThreadPoolTaskExecutor executor, Runnable task) {
        executor.execute(task);
    }

    public void submit(int corePoolSize, int maxPoolSize, int queueCapacity, RejectedExecutionHandler handler, Runnable task) {
        ThreadPoolTaskExecutor executor = this.createThreadPoolTaskExecutor(corePoolSize, maxPoolSize, queueCapacity, handler);
        this.submit(executor, task);
    }

    public void submit(ThreadPoolTaskExecutor executor, Runnable task) {
        executor.submit(task);
    }

    public <T> Future<T> submit(int corePoolSize, int maxPoolSize, int queueCapacity, RejectedExecutionHandler handler, Callable<T> task) {
        ThreadPoolTaskExecutor executor = this.createThreadPoolTaskExecutor(corePoolSize, maxPoolSize, queueCapacity, handler);
        return this.submit(executor, task);
    }

    public <T> Future<T> submit(ThreadPoolTaskExecutor executor, Callable<T> task) {
        return executor.submit(task);
    }

    public void schedule(String cron, Runnable task) {
        this.schedule((Trigger)new CronTrigger(cron), task);
    }

    public void schedule(Trigger trigger, Runnable task) {
        this.threadPoolTaskScheduler.schedule(task, trigger);
    }

    public void schedule(long delay, TimeUnit unit, Runnable task) {
        Date date = new Date(System.currentTimeMillis() + unit.toMillis(delay));
        this.threadPoolTaskScheduler.schedule(task, date);
    }

    public void scheduleAtFixedRate(long initialDelay, long period, TimeUnit unit, Runnable task) {
        Date date = new Date(System.currentTimeMillis() + unit.toMillis(initialDelay));
        this.threadPoolTaskScheduler.scheduleAtFixedRate(task, date, unit.toMillis(period));
    }

    public void scheduleWithFixedDelay(long initialDelay, long delay, TimeUnit unit, Runnable task) {
        Date date = new Date(System.currentTimeMillis() + unit.toMillis(initialDelay));
        this.threadPoolTaskScheduler.scheduleWithFixedDelay(task, date, unit.toMillis(delay));
    }

    public void schedule(int poolSize, String cron, Runnable task) {
        HussarThreadPoolTaskScheduler scheduler = this.createThreadPoolTaskScheduler(poolSize);
        this.schedule(scheduler, cron, task);
    }

    public void schedule(HussarThreadPoolTaskScheduler scheduler, String cron, Runnable task) {
        scheduler.schedule(task, (Trigger)new CronTrigger(cron));
    }

    public void schedule(int poolSize, Trigger trigger, Runnable task) {
        HussarThreadPoolTaskScheduler scheduler = this.createThreadPoolTaskScheduler(poolSize);
        this.schedule(scheduler, trigger, task);
    }

    public void schedule(HussarThreadPoolTaskScheduler scheduler, Trigger trigger, Runnable task) {
        scheduler.schedule(task, trigger);
    }

    public void schedule(int poolSize, long delay, TimeUnit unit, Runnable task) {
        HussarThreadPoolTaskScheduler scheduler = this.createThreadPoolTaskScheduler(poolSize);
        this.schedule(scheduler, delay, unit, task);
    }

    public void schedule(HussarThreadPoolTaskScheduler scheduler, long delay, TimeUnit unit, Runnable task) {
        Date date = new Date(System.currentTimeMillis() + unit.toMillis(delay));
        scheduler.schedule(task, date);
    }

    public void scheduleAtFixedRate(int poolSize, long initialDelay, long period, TimeUnit unit, Runnable task) {
        HussarThreadPoolTaskScheduler scheduler = this.createThreadPoolTaskScheduler(poolSize);
        this.scheduleAtFixedRate(scheduler, initialDelay, period, unit, task);
    }

    public void scheduleAtFixedRate(HussarThreadPoolTaskScheduler scheduler, long initialDelay, long period, TimeUnit unit, Runnable task) {
        Date date = new Date(System.currentTimeMillis() + unit.toMillis(initialDelay));
        scheduler.scheduleAtFixedRate(task, date, unit.toMillis(period));
    }

    public void scheduleWithFixedDelay(int poolSize, long initialDelay, long delay, TimeUnit unit, Runnable task) {
        HussarThreadPoolTaskScheduler scheduler = this.createThreadPoolTaskScheduler(poolSize);
        this.scheduleWithFixedDelay(scheduler, initialDelay, delay, unit, task);
    }

    public void scheduleWithFixedDelay(HussarThreadPoolTaskScheduler scheduler, long initialDelay, long delay, TimeUnit unit, Runnable task) {
        Date date = new Date(System.currentTimeMillis() + unit.toMillis(initialDelay));
        scheduler.scheduleWithFixedDelay(task, date, unit.toMillis(delay));
    }

    public ThreadPoolTaskExecutor createThreadPoolTaskExecutor(int corePoolSize, int maxPoolSize, int queueCapacity, RejectedExecutionHandler handler) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor;
        String key = corePoolSize + ":" + maxPoolSize + ":" + queueCapacity;
        if (handler != null) {
            key = key + ":" + handler.hashCode();
        }
        if ((threadPoolTaskExecutor = this.EXECUTOR_MAP.get(key)) != null) {
            return threadPoolTaskExecutor;
        }
        threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(corePoolSize);
        threadPoolTaskExecutor.setMaxPoolSize(maxPoolSize);
        threadPoolTaskExecutor.setQueueCapacity(queueCapacity);
        threadPoolTaskExecutor.setKeepAliveSeconds(60);
        if (handler == null) {
            threadPoolTaskExecutor.setRejectedExecutionHandler(RejectedExecutionHandlerEnum.instantiationHandler(null));
        } else {
            threadPoolTaskExecutor.setRejectedExecutionHandler(handler);
        }
        threadPoolTaskExecutor.setTaskDecorator((TaskDecorator)new HussarTaskDecorator(this.syncCustomAction));
        threadPoolTaskExecutor.initialize();
        this.EXECUTOR_MAP.put(key, threadPoolTaskExecutor);
        return threadPoolTaskExecutor;
    }

    public HussarThreadPoolTaskScheduler createThreadPoolTaskScheduler(int poolSize) {
        HussarThreadPoolTaskScheduler threadPoolTaskScheduler = this.SCHEDULER_MAP.get(poolSize);
        if (threadPoolTaskScheduler != null) {
            return threadPoolTaskScheduler;
        }
        threadPoolTaskScheduler = new HussarThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(poolSize);
        threadPoolTaskScheduler.setDaemon(true);
        threadPoolTaskScheduler.setTaskDecorator(new HussarTaskDecorator(this.syncCustomAction));
        threadPoolTaskScheduler.initialize();
        this.SCHEDULER_MAP.put(poolSize, threadPoolTaskScheduler);
        return threadPoolTaskScheduler;
    }

    public void destroy() throws Exception {
        this.destroyScheduler();
        this.destroyExecutor();
    }

    private void destroyScheduler() {
        if (HussarUtils.isEmpty(this.SCHEDULER_MAP)) {
            return;
        }
        for (Map.Entry<Object, HussarThreadPoolTaskScheduler> entry : this.SCHEDULER_MAP.entrySet()) {
            entry.getValue().destroy();
        }
        this.SCHEDULER_MAP.clear();
    }

    private void destroyExecutor() {
        if (HussarUtils.isEmpty(this.EXECUTOR_MAP)) {
            return;
        }
        for (Map.Entry<Object, ThreadPoolTaskExecutor> entry : this.EXECUTOR_MAP.entrySet()) {
            entry.getValue().destroy();
        }
        this.EXECUTOR_MAP.clear();
    }

    public ThreadPoolTaskExecutor getThreadPoolTaskExecutor() {
        return this.threadPoolTaskExecutor;
    }

    public ThreadPoolTaskScheduler getThreadPoolTaskScheduler() {
        return this.threadPoolTaskScheduler;
    }
}

