/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.thread.support.taskdecorator;

import com.jxdinfo.hussar.platform.core.http.HussarHttpServletRequest;
import com.jxdinfo.hussar.platform.core.support.service.dto.TenantDetails;
import com.jxdinfo.hussar.platform.core.tenant.util.HussarTenantContextHolder;
import com.jxdinfo.hussar.platform.core.thread.HussarThreadContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.thread.support.custom.HussarSyncCustomAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.task.TaskDecorator;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HussarTaskDecorator
implements TaskDecorator {
    protected static final Logger logger = LoggerFactory.getLogger(HussarTaskDecorator.class);
    private final HussarSyncCustomAction syncCustomAction;

    public HussarTaskDecorator(HussarSyncCustomAction syncCustomAction) {
        this.syncCustomAction = syncCustomAction;
    }

    public Runnable decorate(Runnable runnable) {
        HttpServletRequest request;
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HussarHttpServletRequest hussarHttpServletRequest = null;
        if (HussarUtils.isNotEmpty((Object)attributes) && HussarUtils.isNotEmpty((Object)(request = attributes.getRequest()))) {
            hussarHttpServletRequest = new HussarHttpServletRequest(request);
        }
        HussarHttpServletRequest finalRequest = hussarHttpServletRequest;
        Map shareMap = HussarThreadContextHolder.getCurrentShareMap();
        TenantDetails tenantDetails = HussarTenantContextHolder.getTenant();
        Locale locale = LocaleContextHolder.getLocale();
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.syncCustomAction.beforeSubmit(param);
        return () -> {
            try {
                if (HussarUtils.isNotEmpty((Object)finalRequest)) {
                    RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)finalRequest), (boolean)false);
                }
                HussarThreadContextHolder.setShareMap((Map)shareMap);
                HussarTenantContextHolder.setTenantDetails((TenantDetails)tenantDetails);
                Locale.setDefault(locale);
                this.syncCustomAction.beforeExecute(param);
                runnable.run();
                this.syncCustomAction.afterExecute(param);
            }
            catch (Exception e) {
                logger.info("\u5f02\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
                this.syncCustomAction.error(param);
            }
            finally {
                RequestContextHolder.resetRequestAttributes();
                HussarTenantContextHolder.remove();
                HussarThreadContextHolder.clear();
            }
        };
    }
}

