/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.tenant.interceptor;

import com.jxdinfo.hussar.platform.core.tenant.util.HussarTenantContextHolder;
import com.jxdinfo.hussar.support.tenant.core.support.TenantCreator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class HussarTenantInterceptor
implements HandlerInterceptor {
    @Autowired
    private List<TenantCreator> tenantCreators;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        for (TenantCreator tenantCreator : this.tenantCreators) {
            if (!tenantCreator.support()) continue;
            tenantCreator.createTenantInfo(request);
        }
        return super.preHandle(request, response, handler);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        HussarTenantContextHolder.remove();
        super.afterCompletion(request, response, handler, ex);
    }
}

