/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.tenant.config;

import com.jxdinfo.hussar.support.datasource.config.DynamicDatasourceConfig;
import com.jxdinfo.hussar.support.datasource.support.HeaderDatasourceKey;
import com.jxdinfo.hussar.support.tenant.interceptor.HussarTenantInterceptor;
import com.jxdinfo.hussar.support.tenant.processer.TenantDatasourceKeyProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnProperty(prefix="hussar.core.tenant", name={"enabled"}, havingValue="true", matchIfMissing=false)
@Configuration
@AutoConfigureBefore(value={DynamicDatasourceConfig.class})
public class HussarTenantAutoConfiguration
implements WebMvcConfigurer {
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.hussarTenantInterceptor()).addPathPatterns(new String[]{"/**"});
        super.addInterceptors(registry);
    }

    @Bean
    public HussarTenantInterceptor hussarTenantInterceptor() {
        return new HussarTenantInterceptor();
    }

    @Bean
    public HeaderDatasourceKey headerDatasourceKey() {
        return new TenantDatasourceKeyProcessor();
    }
}

