/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.swagger.config;

import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.swagger.constants.SwaggerConstants;
import com.jxdinfo.hussar.support.swagger.controller.SwaggerTokenController;
import com.jxdinfo.hussar.support.swagger.properties.SwaggerProperties;
import com.jxdinfo.hussar.support.swagger.utils.SwaggerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.OAuthBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.OAuth;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResourceOwnerPasswordCredentialsGrant;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

@EnableSwagger2WebMvc
@Configuration(proxyBeanMethods=false)
@Import(value={BeanValidatorPluginsConfiguration.class})
public class SwaggerAutoConfiguration {
    @Value(value="${server.port}")
    private String port;
    private static final String DEFAULT_BASE_PATH = "/**";
    private static final List<String> DEFAULT_EXCLUDE_PATH = Arrays.asList("/error", "/actuator/**", "/swagger/**");
    private final OpenApiExtensionResolver openApiExtensionResolver;

    @Bean
    @ConditionalOnMissingBean
    public SwaggerProperties swaggerProperties() {
        return new SwaggerProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public Docket api(SwaggerProperties swaggerProperties) {
        if (swaggerProperties.getBasePath().size() == 0) {
            swaggerProperties.getBasePath().add(DEFAULT_BASE_PATH);
        }
        swaggerProperties.getExcludePath().addAll(DEFAULT_EXCLUDE_PATH);
        ApiSelectorBuilder apis = new Docket(DocumentationType.SWAGGER_2).host(swaggerProperties.getHost()).apiInfo(this.apiInfo(swaggerProperties)).ignoredParameterTypes(new Class[]{UserDetails.class}).select().apis(SwaggerUtil.basePackages(swaggerProperties.getBasePackages()));
        swaggerProperties.getBasePath().forEach(p -> apis.paths(PathSelectors.ant((String)p)));
        swaggerProperties.getExcludePath().forEach(p -> apis.paths(PathSelectors.ant((String)p).negate()));
        Docket docket = apis.build().globalOperationParameters(this.setDefaultParams(swaggerProperties));
        if (swaggerProperties.getEnableAuthorize().booleanValue()) {
            docket.securityContexts(this.securityContexts(swaggerProperties)).securitySchemes(this.securitySchemas(swaggerProperties));
        }
        if (this.openApiExtensionResolver != null) {
            docket.extensions(this.openApiExtensionResolver.buildExtensions(SwaggerConstants.APP_NAME));
        }
        return docket.pathMapping("/");
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.swagger", name={"enable-authorize"}, havingValue="true", matchIfMissing=true)
    public SwaggerTokenController swaggerTokenController() {
        return new SwaggerTokenController();
    }

    private List<SecurityContext> securityContexts(SwaggerProperties swaggerProperties) {
        ArrayList<AuthorizationScope> scopes = new ArrayList<AuthorizationScope>();
        scopes.add(new AuthorizationScope("read", "read  resources"));
        scopes.add(new AuthorizationScope("write", "write resources"));
        scopes.add(new AuthorizationScope("reads", "read all resources"));
        scopes.add(new AuthorizationScope("writes", "write all resources"));
        SecurityReference securityReference = new SecurityReference("oauth2", scopes.toArray(new AuthorizationScope[0]));
        SecurityContext securityContext = new SecurityContext((List)Lists.newArrayList((Object[])new SecurityReference[]{securityReference}), PathSelectors.regex((String)swaggerProperties.getAuthRegex()));
        return Lists.newArrayList((Object[])new SecurityContext[]{securityContext});
    }

    private List<SecurityScheme> securitySchemas(SwaggerProperties swaggerProperties) {
        ArrayList<ResourceOwnerPasswordCredentialsGrant> grantTypes = new ArrayList<ResourceOwnerPasswordCredentialsGrant>();
        String passwordTokenUrl = "http://localhost:" + this.port;
        if (HussarUtils.isNotEmpty((Object)swaggerProperties.getLoadTokenUrl())) {
            passwordTokenUrl = swaggerProperties.getLoadTokenUrl();
        }
        ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = new ResourceOwnerPasswordCredentialsGrant(passwordTokenUrl + SwaggerConstants.LOAD_TOKEN_URL);
        grantTypes.add(resourceOwnerPasswordCredentialsGrant);
        OAuth oAuth = new OAuthBuilder().name("oauth2").grantTypes(grantTypes).build();
        return Lists.newArrayList((Object[])new SecurityScheme[]{oAuth});
    }

    private ApiInfo apiInfo(SwaggerProperties swaggerProperties) {
        return new ApiInfoBuilder().title(swaggerProperties.getTitle()).description(swaggerProperties.getDescription()).license(swaggerProperties.getLicense()).licenseUrl(swaggerProperties.getLicenseUrl()).termsOfServiceUrl(swaggerProperties.getTermsOfServiceUrl()).contact(new Contact(swaggerProperties.getContact().getName(), swaggerProperties.getContact().getUrl(), swaggerProperties.getContact().getEmail())).version(swaggerProperties.getVersion()).build();
    }

    private List<Parameter> setDefaultParams(SwaggerProperties swaggerProperties) {
        ArrayList<Parameter> pars = new ArrayList<Parameter>();
        pars.add(new ParameterBuilder().name(SwaggerConstants.CLIENT_ID).description("client-id").defaultValue(swaggerProperties.getClientId()).modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(false).build());
        pars.add(new ParameterBuilder().name(SwaggerConstants.SWAGGER).description("\u6807\u8bc6\u8bf7\u6c42\u4eceswagger\u63a5\u53e3\u6587\u6863\u53d1\u51fa").defaultValue("true").modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(false).build());
        return pars;
    }

    public SwaggerAutoConfiguration(@Autowired(required=false) OpenApiExtensionResolver openApiExtensionResolver) {
        this.openApiExtensionResolver = openApiExtensionResolver;
    }
}

