/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.swagger.controller;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.swagger.Exception.SwaggerException;
import com.jxdinfo.hussar.support.swagger.constants.SwaggerConstants;
import com.jxdinfo.hussar.support.swagger.controller.LoginInfoDTO;
import com.jxdinfo.hussar.support.swagger.controller.TokenResponse;
import com.jxdinfo.hussar.support.swagger.properties.SwaggerProperties;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/swagger"})
public class SwaggerTokenController {
    private static Logger log = LoggerFactory.getLogger(SwaggerTokenController.class);
    private static String AUTHORIZE_URL = "/oauth2/token?grant_type=password";
    private OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
    @Autowired
    private SwaggerProperties swaggerProperties;

    @PostMapping(value={"/oauth/token"})
    public TokenResponse getToken(LoginInfoDTO loginInfoDTO) {
        String url = this.swaggerProperties.getAuthServer() + AUTHORIZE_URL;
        Map<String, Object> authorizeInfo = this.doAuthorize(url, loginInfoDTO);
        return new TokenResponse(authorizeInfo.get(SwaggerConstants.ACCESS_TOKEN), authorizeInfo.get(SwaggerConstants.EXPIRES_IN));
    }

    private Map<String, Object> doAuthorize(String url, LoginInfoDTO loginInfo) {
        FormBody formBody = new FormBody.Builder().add(SwaggerConstants.USER_NAME, loginInfo.getUsername()).add(SwaggerConstants.PASSWORD, loginInfo.getPassword()).add(SwaggerConstants.IS_INDEX, "index").add(SwaggerConstants.SWAGGER, Boolean.TRUE.toString()).build();
        Request request = new Request.Builder().url(url).addHeader(SwaggerConstants.CLIENT_ID, this.swaggerProperties.getClientId()).post((RequestBody)formBody).build();
        try {
            Response response = this.client.newCall(request).execute();
            if (response == null || response.code() != 200) {
                throw new SwaggerException("httpClient \u8bf7\u6c42\u5931\u8d25");
            }
            String resultStr = response.body().string();
            log.info("swagger \u8ba4\u8bc1\u7ed3\u679c\u4e3a:{}", (Object)resultStr);
            ApiResponse apiResponse = (ApiResponse)JsonUtil.parse((String)resultStr, ApiResponse.class);
            if (apiResponse == null || apiResponse.getCode() != ResultCode.SUCCESS.getCode()) {
                throw new SwaggerException("\u8ba4\u8bc1\u63a5\u53e3\u5904\u7406\u5931\u8d25");
            }
            return (Map)apiResponse.getData();
        }
        catch (IOException e) {
            throw new SwaggerException("swagger \u8ba4\u8bc1\u5931\u8d25", e);
        }
    }
}

