/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.serialiaztion.config;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.config.HussarCoreProperties;
import com.jxdinfo.hussar.platform.core.serialize.ApiResponseJsonDeserializer;
import com.jxdinfo.hussar.platform.core.serialize.HussarJavaTimeModule;
import com.jxdinfo.hussar.platform.core.serialize.HussarLocalDateTimeDeserializer;
import com.jxdinfo.hussar.platform.core.serialize.HussarNumberModule;
import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.support.serialiaztion.properties.HussarJacksonProperties;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.TimeZone;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ObjectMapper.class})
@AutoConfigureBefore(value={JacksonAutoConfiguration.class})
@EnableConfigurationProperties(value={HussarJacksonProperties.class, HussarCoreProperties.class})
public class JacksonConfiguration {
    @Primary
    @Bean
    public ObjectMapper objectMapper(Jackson2ObjectMapperBuilder builder, HussarJacksonProperties hussarJacksonProperties, HussarCoreProperties hussarCoreProperties) {
        builder.simpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ObjectMapper objectMapper = builder.createXmlMapper(false).build();
        objectMapper.setLocale(Locale.CHINA);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.setTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault()));
        objectMapper.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);
        objectMapper.configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature(), true);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        objectMapper.configure(JsonReadFeature.ALLOW_SINGLE_QUOTES.mappedFeature(), true);
        objectMapper.getDeserializationConfig().withoutFeatures(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
        HussarJavaTimeModule hussarJavaTimeModule = new HussarJavaTimeModule(hussarCoreProperties);
        objectMapper.registerModule((Module)hussarJavaTimeModule);
        if (Boolean.TRUE.equals(hussarJacksonProperties.getBigNumToString())) {
            objectMapper.registerModules(new Module[]{HussarNumberModule.INSTANCE});
        }
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(hussarCoreProperties.getSerializerDateTimeFormatter(), Locale.CHINA));
        objectMapper.findAndRegisterModules();
        return objectMapper;
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer(HussarCoreProperties hussarCoreProperties) {
        return builder -> {
            builder.serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeUtil.DATETIME_FORMAT));
            builder.deserializerByType(LocalDateTime.class, (JsonDeserializer)new HussarLocalDateTimeDeserializer(DateTimeFormatter.ofPattern(hussarCoreProperties.getDeserializerDateTimeFormatter()), hussarCoreProperties.getSupportDateTimeFormatterSets()));
            builder.serializerByType(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeUtil.DATE_FORMAT));
            builder.deserializerByType(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeUtil.DATE_FORMAT));
            builder.serializerByType(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeUtil.TIME_FORMAT));
            builder.deserializerByType(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeUtil.TIME_FORMAT));
            builder.deserializerByType(ApiResponse.class, (JsonDeserializer)new ApiResponseJsonDeserializer());
        };
    }
}

