/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.serialiaztion.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.google.common.base.Charsets;
import com.jxdinfo.hussar.platform.core.serialize.HussarBeanSerializerModifier;
import com.jxdinfo.hussar.platform.core.serialize.HussarNumberModule;
import com.jxdinfo.hussar.support.serialiaztion.jackson.AbstractReadWriteJackson2HttpMessageConverter;
import com.jxdinfo.hussar.support.serialiaztion.properties.HussarJacksonProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;

public class MappingApiJackson2HttpMessageConverter
extends AbstractReadWriteJackson2HttpMessageConverter {
    @Nullable
    private String jsonPrefix;

    public MappingApiJackson2HttpMessageConverter(ObjectMapper objectMapper, HussarJacksonProperties properties) {
        super(objectMapper, MappingApiJackson2HttpMessageConverter.initWriteObjectMapper(objectMapper, properties), MappingApiJackson2HttpMessageConverter.initMediaType(properties));
    }

    private static List<MediaType> initMediaType(HussarJacksonProperties properties) {
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        supportedMediaTypes.add(new MediaType("application", "*+json"));
        if (Boolean.TRUE.equals(properties.getSupportTextPlain())) {
            supportedMediaTypes.add(MediaType.TEXT_PLAIN);
        }
        return supportedMediaTypes;
    }

    private static ObjectMapper initWriteObjectMapper(ObjectMapper readObjectMapper, HussarJacksonProperties properties) {
        ObjectMapper writeObjectMapper = readObjectMapper.copy();
        if (Boolean.TRUE.equals(properties.getBigNumToString())) {
            writeObjectMapper.registerModules(new Module[]{HussarNumberModule.INSTANCE});
        }
        if (Boolean.TRUE.equals(properties.getNullToEmpty())) {
            writeObjectMapper.setSerializerFactory(writeObjectMapper.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)new HussarBeanSerializerModifier()));
            writeObjectMapper.getSerializerProvider().setNullValueSerializer(HussarBeanSerializerModifier.NullJsonSerializers.STRING_JSON_SERIALIZER);
        }
        return writeObjectMapper;
    }

    @Override
    protected void writeInternal(@NonNull Object object, @Nullable Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (object instanceof String) {
            Charset defaultCharset = this.getDefaultCharset();
            Charset charset = defaultCharset == null ? Charsets.UTF_8 : defaultCharset;
            StreamUtils.copy((String)((String)object), (Charset)charset, (OutputStream)outputMessage.getBody());
        } else {
            super.writeInternal(object, type, outputMessage);
        }
    }

    public void setJsonPrefix(@Nullable String jsonPrefix) {
        this.jsonPrefix = jsonPrefix;
    }

    public void setPrefixJson(boolean prefixJson) {
        this.jsonPrefix = prefixJson ? ")]}', " : null;
    }

    protected void writePrefix(@NonNull JsonGenerator generator, @NonNull Object object) throws IOException {
        if (this.jsonPrefix != null) {
            generator.writeRaw(this.jsonPrefix);
        }
    }
}

