/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.serialiaztion.config;

import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.support.ConcurrentDateFormat;
import com.jxdinfo.hussar.support.serialiaztion.exception.SerialiaztionParseException;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class DateHandlerConverterConfiguration {
    @Bean
    public Converter<String, LocalDate> localDateConverter() {
        return new Converter<String, LocalDate>(){

            public LocalDate convert(String source) {
                return LocalDate.parse(source, DateUtil.DATE_FORMATTER);
            }
        };
    }

    @Bean
    public Converter<String, LocalDateTime> localDateTimeConverter() {
        return new Converter<String, LocalDateTime>(){

            public LocalDateTime convert(String source) {
                return LocalDateTime.parse(source, DateUtil.DATETIME_FORMATTER);
            }
        };
    }

    @Bean
    public Converter<String, LocalTime> localTimeConverter() {
        return new Converter<String, LocalTime>(){

            public LocalTime convert(String source) {
                return LocalTime.parse(source, DateUtil.TIME_FORMATTER);
            }
        };
    }

    @Bean
    public Converter<String, Date> dateConverter() {
        return new Converter<String, Date>(){

            public Date convert(String source) {
                ConcurrentDateFormat datetimeFormat = DateUtil.DATETIME_FORMAT;
                try {
                    return datetimeFormat.parse(source);
                }
                catch (ParseException e) {
                    throw new SerialiaztionParseException();
                }
            }
        };
    }
}

