/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.serialiaztion.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.support.serialiaztion.jackson.MappingApiJackson2HttpMessageConverter;
import com.jxdinfo.hussar.support.serialiaztion.properties.HussarJacksonProperties;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.ResourceRegionHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@Order(value=-2147483648)
public class MessageConfiguration
implements WebMvcConfigurer {
    private final ObjectMapper objectMapper;
    private final HussarJacksonProperties properties;

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.removeIf(x -> x instanceof StringHttpMessageConverter || x instanceof AbstractJackson2HttpMessageConverter);
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(StandardCharsets.UTF_8));
        converters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new ResourceRegionHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new MappingApiJackson2HttpMessageConverter(this.objectMapper, this.properties));
    }

    public MessageConfiguration(ObjectMapper objectMapper, HussarJacksonProperties properties) {
        this.objectMapper = objectMapper;
        this.properties = properties;
    }
}

