/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.exception.mvc.support;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.mvc.support.HussarHandlerMethodArgumentResolverCustomizers;
import com.jxdinfo.hussar.support.exception.mvc.support.resolver.HussarRequestParamMethodArgumentResolver;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.web.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;

public class HussarExceptionHandlerMethodArgumentResolverCustomizers
implements HussarHandlerMethodArgumentResolverCustomizers {
    private static final Logger log = LoggerFactory.getLogger(HussarExceptionHandlerMethodArgumentResolverCustomizers.class);

    @Override
    public boolean support(HandlerMethodArgumentResolver handlerMethodArgumentResolver) {
        return handlerMethodArgumentResolver instanceof RequestParamMethodArgumentResolver;
    }

    @Override
    public HandlerMethodArgumentResolver customize(ConfigurableBeanFactory beanFactory, HandlerMethodArgumentResolver handlerMethodArgumentResolver, List<HandlerMethodArgumentResolver> coverArgumentResolvers) {
        boolean flag = this.isRepeatHandlerMethodArgumentResolver(coverArgumentResolvers);
        HussarRequestParamMethodArgumentResolver hussarRequestParamMethodArgumentResolver = new HussarRequestParamMethodArgumentResolver(beanFactory, flag);
        return hussarRequestParamMethodArgumentResolver;
    }

    private boolean isRepeatHandlerMethodArgumentResolver(List<HandlerMethodArgumentResolver> coverArgumentResolvers) {
        if (HussarUtils.isEmpty(coverArgumentResolvers)) {
            return false;
        }
        Optional<HandlerMethodArgumentResolver> optional = coverArgumentResolvers.stream().filter(s -> s instanceof HussarRequestParamMethodArgumentResolver).findFirst();
        return optional.isPresent();
    }

    @Override
    public int order() {
        return 1;
    }
}

