/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.exception.config;

import com.jxdinfo.hussar.support.exception.error.HussarErrorController;
import com.jxdinfo.hussar.support.exception.mvc.RequestMappingHandlerAdapterBeanPostProcessor;
import javax.servlet.Servlet;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication
@AutoConfigureBefore(value={ErrorMvcAutoConfiguration.class})
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
public class HussarErrorMvcAutoConfiguration {
    private final ServerProperties serverProperties;

    public HussarErrorMvcAutoConfiguration(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorAttributes.class}, search=SearchStrategy.CURRENT)
    public DefaultErrorAttributes errorAttributes() {
        return new DefaultErrorAttributes();
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorController.class}, search=SearchStrategy.CURRENT)
    public BasicErrorController basicErrorController(ErrorAttributes errorAttributes) {
        return new HussarErrorController(errorAttributes, this.serverProperties.getError());
    }

    @Bean
    public RequestMappingHandlerAdapterBeanPostProcessor requestMappingHandlerAdapterBeanPostProcessor() {
        return new RequestMappingHandlerAdapterBeanPostProcessor();
    }
}

