/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.exception.handler;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.log.trace.annotation.Trace;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@RestControllerAdvice
@Order(value=0x7FFFFFFE)
@Trace
public class HussarGlobalExceptionHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(HussarGlobalExceptionHandler.class);
    @Autowired
    private MultipartProperties multipartProperties;

    @ExceptionHandler(value={MyBatisSystemException.class})
    public ApiResponse<?> handlerException(MyBatisSystemException e, HttpServletRequest request, HttpServletResponse response) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            LOGGER.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751fmybatis\u5f02\u5e38{}\uff0c\u5f02\u5e38\u4fe1\u606f[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            LOGGER.error("\u53d1\u751fsql\u5f02\u5e38\uff0cMyBatisSystemException:\u5f02\u5e38\u4fe1\u606f[{}]", (Object)e.getMessage());
        }
        e.printStackTrace();
        this.doResponse(response);
        return ApiResponse.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={BadSqlGrammarException.class})
    public ApiResponse<?> handlerException(BadSqlGrammarException e, HttpServletRequest request, HttpServletResponse response) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            LOGGER.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751fsql\u5f02\u5e38{}\uff0c\u5f02\u5e38\u4fe1\u606f[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            LOGGER.error("\u53d1\u751fsql\u5f02\u5e38\uff0cMyBatisSystemException:\u5f02\u5e38\u4fe1\u606f[{}]", (Object)e.getMessage());
        }
        e.printStackTrace();
        this.doResponse(response);
        return ApiResponse.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={HussarException.class})
    public ApiResponse<?> handlerException(HussarException e, HttpServletRequest request, HttpServletResponse response) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            LOGGER.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38{},\u5f02\u5e38code:[{}]\uff0c\u5f02\u5e38\u4fe1\u606f[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getExceptionCode(), e.getMessage()});
        } else {
            LOGGER.error("\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38\uff0cHussarException:\u5f02\u5e38code:[{}]\uff0c\u5f02\u5e38\u4fe1\u606f[{}]", (Object)e.getExceptionCode(), (Object)e.getMessage());
        }
        e.printStackTrace();
        this.doResponse(response);
        return ApiResponse.fail((int)e.getExceptionCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @Trace
    public ApiResponse<?> handlerException(HttpRequestMethodNotSupportedException e, HttpServletRequest request, HttpServletResponse response) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            LOGGER.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38\uff0c{}:[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            LOGGER.error("\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38\uff0c{}:[{}]", e.getClass(), (Object)e.getMessage());
        }
        this.doResponse(response);
        e.printStackTrace();
        return ApiResponse.fail((int)405, (String)e.getMessage());
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    @Trace
    public ApiResponse<?> handlerException(MaxUploadSizeExceededException e, HttpServletRequest request, HttpServletResponse response) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            LOGGER.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38\uff0c{}:[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            LOGGER.error("\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38\uff0c{}:[{}]", e.getClass(), (Object)e.getMessage());
        }
        this.doResponse(response);
        return ApiResponse.fail((String)("\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u670d\u52a1\u5668\u5141\u8bb8\u6587\u4ef6\u5927\u5c0f\u9650\u5236\uff0c\u6700\u5927\u5141\u8bb8\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1a" + this.multipartProperties.getMaxFileSize().toBytes() + "bytes\u3002"));
    }

    @ExceptionHandler(value={Exception.class})
    @Trace
    public ApiResponse<?> handlerException(Exception e, HttpServletRequest request, HttpServletResponse response) {
        if (request != null && !StringUtils.isEmpty((Object)request.getRequestURI())) {
            LOGGER.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c{}:[{}]", new Object[]{request.getRequestURI(), e.getClass(), e.getMessage()});
        } else {
            LOGGER.error("\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c{}:[{}]", e.getClass(), (Object)e.getMessage());
        }
        this.doResponse(response);
        e.printStackTrace();
        return ApiResponse.fail((String)"\u53d1\u751f\u672a\u77e5\u5f02\u5e38....");
    }

    private void doResponse(HttpServletResponse response) {
        if (!StringUtil.equalsIgnoreCase((CharSequence)response.getContentType(), (CharSequence)"application/json")) {
            response.setContentType("application/json");
        }
    }
}

