/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.exception.error;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.IResultCode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.WebRequest;

public class HussarErrorAttributes
extends DefaultErrorAttributes {
    private static Logger log = LoggerFactory.getLogger(HussarErrorAttributes.class);

    public Map<String, Object> getErrorAttributes(WebRequest webRequest, boolean includeStackTrace) {
        ApiResponse result;
        String requestUri = (String)this.getAttr(webRequest, "javax.servlet.error.request_uri");
        Integer status = (Integer)this.getAttr(webRequest, "javax.servlet.error.status_code");
        Throwable error = this.getError(webRequest);
        if (error == null) {
            log.error("URL:{} error status:{}", (Object)requestUri, (Object)status);
            result = ApiResponse.fail((IResultCode)ResultCode.FAILURE, (String)("\u7cfb\u7edf\u672a\u77e5\u5f02\u5e38[HttpStatus]:" + status));
        } else {
            log.error(String.format("URL:%s error status:%d", requestUri, status), error);
            result = ApiResponse.fail((int)status, (String)error.getMessage());
        }
        return BeanUtil.beanToMap((Object)result);
    }

    @Nullable
    private <T> T getAttr(WebRequest webRequest, String name) {
        return (T)webRequest.getAttribute(name, 0);
    }
}

