/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.datasource.config;

import com.jxdinfo.hussar.platform.core.spring.HussarSpringApplicationProperties;
import com.jxdinfo.hussar.support.datasource.config.DynamicDatasourceConfig;
import com.jxdinfo.hussar.support.datasource.listener.SyncDynamicDataSourceListener;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.datasource.support.service.SyncDynamicDatasourceService;
import com.jxdinfo.hussar.support.datasource.support.service.impl.DefaultSyncDynamicDatasourceService;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

@Configuration
@AutoConfigureAfter(value={DynamicDatasourceConfig.class})
@ConditionalOnExpression(value="'${hussar.cache.cache-type:ehcache}'.equals('redis') and ${spring.datasource.dynamic.sync.enable:true}")
@EnableConfigurationProperties(value={HussarSpringApplicationProperties.class})
public class SyncDynamicDataSourceConfig {
    @Bean
    @ConditionalOnMissingBean
    public SyncDynamicDatasourceService syncDynamicDatasourceService(HussarSpringApplicationProperties springApplicationProperties, DynamicDatasourceService dynamicDatasourceService) {
        return new DefaultSyncDynamicDatasourceService(springApplicationProperties, dynamicDatasourceService);
    }

    @Bean
    public SyncDynamicDataSourceListener syncDynamicDataSourceListener(SyncDynamicDatasourceService syncDynamicDatasourceService) {
        return new SyncDynamicDataSourceListener(syncDynamicDatasourceService);
    }

    @Bean
    public RedisMessageListenerContainer syncDsRedisContainer(RedisConnectionFactory redisConnectionFactory, SyncDynamicDataSourceListener syncDynamicDataSourceListener) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(redisConnectionFactory);
        container.addMessageListener((MessageListener)syncDynamicDataSourceListener, (Topic)new ChannelTopic("sync_dynamic_datasource_channel"));
        return container;
    }
}

