/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.datasource.support.service.impl;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.jxdinfo.hussar.platform.core.spring.HussarSpringApplicationProperties;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.listener.SyncDynamicDataSourceMessage;
import com.jxdinfo.hussar.support.datasource.properties.HussarSyncDynamicDatasourceProperties;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.datasource.support.service.SyncDynamicDatasourceService;
import com.jxdinfo.hussar.support.datasource.support.service.dto.DynamicDataSourceDto;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSyncDynamicDatasourceService
implements SyncDynamicDatasourceService {
    private static final Logger log = LoggerFactory.getLogger(AbstractSyncDynamicDatasourceService.class);
    private final HussarSpringApplicationProperties springApplicationProperties;
    private final DynamicDatasourceService dynamicDatasourceService;

    public AbstractSyncDynamicDatasourceService(HussarSpringApplicationProperties springApplicationProperties, DynamicDatasourceService dynamicDatasourceService) {
        this.springApplicationProperties = springApplicationProperties;
        this.dynamicDatasourceService = dynamicDatasourceService;
    }

    @Override
    public void syncDynamicDatasource(SyncDynamicDataSourceMessage syncDynamicDataSourceMessage) {
        if (!this.enableSyncApplicationName(syncDynamicDataSourceMessage)) {
            return;
        }
        log.info("applicationName[" + this.springApplicationProperties.getName() + "]\u63a5\u6536\u5230\u540c\u6b65\u6570\u636e\u6e90\u7684\u8bf7\u6c42");
        DynamicDataSourceDto dynamicDataSourceDto = syncDynamicDataSourceMessage.getDynamicDataSourceDto();
        if (HussarUtils.isEmpty((Object)dynamicDataSourceDto) || HussarUtils.isEmpty((Object)dynamicDataSourceDto.getPoolName()) || HussarUtils.isEmpty((Object)dynamicDataSourceDto.getUserName()) || HussarUtils.isEmpty((Object)dynamicDataSourceDto.getPassword()) || HussarUtils.isEmpty((Object)dynamicDataSourceDto.getUrl()) || HussarUtils.isEmpty((Object)dynamicDataSourceDto.getDriverClassName())) {
            log.error("\u540c\u6b65\u6570\u636e\u6e90\uff0c\u6570\u636e\u6e90\u4fe1\u606f\u7f3a\u5c11\u53c2\u6570");
            return;
        }
        log.info("\u63a5\u6536\u5230\u540c\u6b65\u6570\u636e\u6e90[" + dynamicDataSourceDto.getPoolName() + "]");
        ItemDataSource itemDataSource = this.dynamicDatasourceService.existDatasource(dynamicDataSourceDto.getPoolName());
        if (HussarUtils.isEmpty((Object)itemDataSource) || !HussarUtils.equals((Object)itemDataSource.getPoolName(), (Object)dynamicDataSourceDto.getPoolName())) {
            log.info("applicationName[" + this.springApplicationProperties.getName() + "],\u9700\u8981\u8fdb\u884c\u540c\u6b65\u6570\u636e\u6e90\u4fe1\u606f[" + dynamicDataSourceDto.getPoolName() + "]");
            this.doSyncDynamicDatasource(syncDynamicDataSourceMessage);
        }
    }

    public HussarSpringApplicationProperties getSpringApplicationProperties() {
        return this.springApplicationProperties;
    }

    public DynamicDatasourceService getDynamicDatasourceService() {
        return this.dynamicDatasourceService;
    }

    private boolean enableSyncApplicationName(SyncDynamicDataSourceMessage syncDynamicDataSourceMessage) {
        if (HussarUtils.isEmpty((Object)syncDynamicDataSourceMessage) || HussarUtils.isEmpty((Object)syncDynamicDataSourceMessage.getSourceApplicationName()) || HussarUtils.isEmpty((Object)syncDynamicDataSourceMessage.getHussarSyncDynamicDatasourceProperties())) {
            return false;
        }
        log.info("\u5224\u65ad\u662f\u5426\u8fdb\u884c\u540c\u6b65\u7684\u5904\u7406\u903b\u8f91\uff1a\u5f53\u524dapplicationName[" + this.springApplicationProperties.getName() + "]\uff0c\u4fee\u6539\u6570\u636e\u6e90\u7684applicationname\uff1a" + syncDynamicDataSourceMessage.getSourceApplicationName());
        HussarSyncDynamicDatasourceProperties hussarSyncDynamicDatasourceProperties = syncDynamicDataSourceMessage.getHussarSyncDynamicDatasourceProperties();
        String sourceApplicationName = syncDynamicDataSourceMessage.getSourceApplicationName();
        List<String> excludeApplicationName = hussarSyncDynamicDatasourceProperties.getExcludeApplicationName();
        boolean sourceEnable = sourceApplicationName.equalsIgnoreCase(this.springApplicationProperties.getName());
        boolean exclude = CollectionUtil.contains(excludeApplicationName, (Object)this.springApplicationProperties.getName());
        log.info("\u5224\u65ad\u662f\u5426\u8fdb\u884c\u540c\u6b65\u7684\u5904\u7406\u903b\u8f91\uff1a\u662f\u5426\u9700\u8981\u8fdb\u884c\u6392\u9664applicationName \uff1a" + exclude);
        return sourceEnable && !exclude;
    }
}

