/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.datasource.aop;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.properties.HussarDynamicProperties;
import com.jxdinfo.hussar.support.datasource.support.HeaderDatasourceKey;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class DynamicDataSourceAutoSwitchInterceptor
implements MethodInterceptor {
    private final HussarDynamicProperties dynamicProperties;
    private final HeaderDatasourceKey headerDatasourceKey;

    public DynamicDataSourceAutoSwitchInterceptor(HussarDynamicProperties dynamicProperties, HeaderDatasourceKey headerDatasourceKey) {
        this.headerDatasourceKey = headerDatasourceKey;
        this.dynamicProperties = dynamicProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, DS.class)) {
            return invocation.proceed();
        }
        String dsKey = this.headerDatasourceKey.processSourceKeyByHeader(invocation, this.dynamicProperties.getDatasourceKeyByHeader());
        if (HussarUtils.isEmpty((Object)dsKey)) {
            return invocation.proceed();
        }
        DynamicDataSourceContextHolder.push((String)dsKey);
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }
}

