/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.datasource.support.service.impl;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.creator.DefaultDataSourceCreator;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.jxdinfo.hussar.platform.core.spring.HussarSpringApplicationProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import com.jxdinfo.hussar.support.datasource.exception.DynamicDatasourceException;
import com.jxdinfo.hussar.support.datasource.listener.HussarDatasourceChangeListener;
import com.jxdinfo.hussar.support.datasource.listener.SyncDynamicDataSourceMessage;
import com.jxdinfo.hussar.support.datasource.properties.HussarSyncDynamicDatasourceProperties;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.datasource.support.service.dto.DynamicDataSourceDto;
import com.jxdinfo.hussar.support.datasource.util.DynamicDatasourceUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class DefaultDynamicDatasourceService
implements DynamicDatasourceService {
    private static final Logger log = LoggerFactory.getLogger(DefaultDynamicDatasourceService.class);
    @Autowired
    private DataSource dataSource;
    @Autowired
    private DefaultDataSourceCreator dataSourceCreator;
    @Autowired
    private DynamicDataSourceProperties properties;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private HussarCacheProperties hussarCacheProperties;
    @Autowired
    private HussarSpringApplicationProperties springApplicationProperties;
    @Autowired
    private HussarSyncDynamicDatasourceProperties hussarSyncDynamicDatasourceProperties;
    private List<HussarDatasourceChangeListener> hussarDatasourceChangeListeners;

    @Override
    public void addDynamicDatasource(DynamicDataSourceDto dynamicDataSourceDto) {
        this.syncDatasourceMemory(dynamicDataSourceDto);
        if (HussarUtils.isNotEmpty((Object)this.redisTemplate) && "redis".equals(this.hussarCacheProperties.getCacheType()) && this.hussarSyncDynamicDatasourceProperties.isEnable()) {
            SyncDynamicDataSourceMessage syncDynamicDataSourceMessage = new SyncDynamicDataSourceMessage(dynamicDataSourceDto, this.springApplicationProperties.getName(), this.hussarSyncDynamicDatasourceProperties);
            this.redisTemplate.convertAndSend("sync_dynamic_datasource_channel", (Object)syncDynamicDataSourceMessage);
        }
    }

    @Override
    public void removeDynamicDatasource(String name) {
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        ds.removeDataSource(name);
        if (HussarUtils.isNotEmpty(this.hussarDatasourceChangeListeners)) {
            this.hussarDatasourceChangeListeners.forEach(listener -> listener.deleteDatasourceListener(name, (DataSource)this.getDatasourceByPoolName(name)));
        }
    }

    @Override
    public Set<String> getAllDatasourcesName() {
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        Map dataSources = ds.getDataSources();
        if (HussarUtils.isNotEmpty((Object)dataSources)) {
            return ds.getDataSources().keySet();
        }
        return null;
    }

    @Override
    public String getCurrentDatasourceName() {
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        DataSource dataSource = ds.determineDataSource();
        if (HussarUtils.isEmpty((Object)dataSource)) {
            return null;
        }
        ItemDataSource itemDataSource = null;
        String currentName = null;
        try {
            itemDataSource = (ItemDataSource)dataSource;
            currentName = itemDataSource.getName();
        }
        catch (Exception e) {
            throw new DynamicDatasourceException("\u83b7\u53d6\u4e3a\u7a7a");
        }
        return currentName;
    }

    @Override
    public ItemDataSource getCurrentDatasource() {
        ItemDataSource itemDataSource;
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        DataSource dataSource = ds.determineDataSource();
        if (HussarUtils.isEmpty((Object)dataSource)) {
            return null;
        }
        try {
            itemDataSource = (ItemDataSource)dataSource;
        }
        catch (Exception e) {
            throw new DynamicDatasourceException("\u83b7\u53d6\u4e3a\u7a7a");
        }
        return itemDataSource;
    }

    @Override
    public ItemDataSource getDatasourceByPoolName(String name) {
        ItemDataSource itemDataSource;
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        DataSource dataSource = ds.getDataSource(name);
        try {
            itemDataSource = (ItemDataSource)dataSource;
        }
        catch (Exception e) {
            throw new DynamicDatasourceException("\u83b7\u53d6\u4e3a\u7a7a");
        }
        return itemDataSource;
    }

    @Override
    public List<ItemDataSource> getAllDatasources() {
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        Map dataSources = ds.getDataSources();
        if (HussarUtils.isNotEmpty((Object)dataSources)) {
            List hussarItemDataSources = ds.getDataSources().entrySet().stream().map(entry -> {
                if (entry.getValue() instanceof ItemDataSource) {
                    return (ItemDataSource)entry.getValue();
                }
                return null;
            }).collect(Collectors.toList());
            List<ItemDataSource> collect = hussarItemDataSources.stream().filter(idatasource -> HussarUtils.isNotEmpty((Object)idatasource)).collect(Collectors.toList());
            return collect;
        }
        return null;
    }

    @Override
    public void syncDatasourceMemory(DynamicDataSourceDto dynamicDataSourceDto) {
        DynamicDatasourceException.throwBy(HussarUtils.isEmpty((Object)dynamicDataSourceDto), "\u6570\u636e\u6e90\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy(HussarUtils.isEmpty((Object)dynamicDataSourceDto.getPoolName()), "\u6570\u636e\u6e90name\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy(HussarUtils.isEmpty((Object)dynamicDataSourceDto.getUserName()), "\u6570\u636e\u6e90username\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy(HussarUtils.isEmpty((Object)dynamicDataSourceDto.getPassword()), "\u6570\u636e\u6e90password\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy(HussarUtils.isEmpty((Object)dynamicDataSourceDto.getUrl()), "\u6570\u636e\u6e90url\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DynamicDatasourceException.throwBy(HussarUtils.isEmpty((Object)dynamicDataSourceDto.getDriverClassName()), "\u6570\u636e\u6e90\u9a71\u52a8\u4e3a\u7a7a\uff0c\u6dfb\u52a0\u5931\u8d25");
        DataSourceProperty datasourceProperty = DynamicDatasourceUtils.createDatasourceProperty(this.properties, dynamicDataSourceDto);
        DataSource newDataSource = this.dataSourceCreator.createDataSource(datasourceProperty);
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        ds.addDataSource(dynamicDataSourceDto.getPoolName(), newDataSource);
        if (HussarUtils.isNotEmpty(this.hussarDatasourceChangeListeners)) {
            this.hussarDatasourceChangeListeners.forEach(listener -> listener.addDatasourceListener(dynamicDataSourceDto.getPoolName(), newDataSource));
        }
    }

    public List<HussarDatasourceChangeListener> getHussarDatasourceChangeListeners() {
        return this.hussarDatasourceChangeListeners;
    }

    public void setHussarDatasourceChangeListeners(List<HussarDatasourceChangeListener> hussarDatasourceChangeListeners) {
        this.hussarDatasourceChangeListeners = hussarDatasourceChangeListeners;
    }
}

