/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.datasource.listener;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.listener.SyncDynamicDataSourceMessage;
import com.jxdinfo.hussar.support.datasource.support.service.SyncDynamicDatasourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;

public class SyncDynamicDataSourceListener
implements MessageListener {
    @Autowired
    private RedisTemplate redisTemplate;
    private SyncDynamicDatasourceService syncDynamicDatasourceService;

    public SyncDynamicDataSourceListener(SyncDynamicDatasourceService syncDynamicDatasourceService) {
        this.syncDynamicDatasourceService = syncDynamicDatasourceService;
    }

    public void onMessage(Message message, byte[] bytes) {
        if (HussarUtils.isEmpty((Object)this.redisTemplate) || HussarUtils.isEmpty((Object)this.redisTemplate.getValueSerializer()) || HussarUtils.isEmpty((Object)message.getBody())) {
            return;
        }
        Object object = this.redisTemplate.getValueSerializer().deserialize(message.getBody());
        if (HussarUtils.isNotEmpty((Object)object) && object instanceof SyncDynamicDataSourceMessage) {
            SyncDynamicDataSourceMessage syncMessage = (SyncDynamicDataSourceMessage)object;
            this.syncDynamicDatasourceService.syncDynamicDatasource(syncMessage);
        }
    }
}

