/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.datasource.config;

import com.baomidou.dynamic.datasource.processor.DsProcessor;
import com.baomidou.dynamic.datasource.processor.DsSpelExpressionProcessor;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceAutoConfiguration;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.jxdinfo.hussar.support.datasource.aop.DynamicDataSourceAutoSwitchInterceptor;
import com.jxdinfo.hussar.support.datasource.aop.DynamicDatasourceAutoSwitchAdvisor;
import com.jxdinfo.hussar.support.datasource.properties.DynamicMasterDatasourceProperties;
import com.jxdinfo.hussar.support.datasource.properties.HussarDynamicProperties;
import com.jxdinfo.hussar.support.datasource.properties.HussarSyncDynamicDatasourceProperties;
import com.jxdinfo.hussar.support.datasource.support.DefaultHeaderDatasourceKeyProcesser;
import com.jxdinfo.hussar.support.datasource.support.DynamicDsTokenProcessor;
import com.jxdinfo.hussar.support.datasource.support.HeaderDatasourceKey;
import com.jxdinfo.hussar.support.datasource.support.JdbcDynamicDataSourceProvider;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.datasource.support.service.impl.DefaultDynamicDatasourceService;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.stereotype.Controller;

@Configuration
@AutoConfigureBefore(value={DynamicDataSourceAutoConfiguration.class})
@EnableConfigurationProperties(value={HussarDynamicProperties.class, DynamicMasterDatasourceProperties.class, HussarSyncDynamicDatasourceProperties.class, DynamicDataSourceProperties.class})
public class DynamicDatasourceConfig {
    private HussarDynamicProperties hussarDynamicProperties;
    private DynamicMasterDatasourceProperties dynamicMasterDatasourceProperties;
    private DynamicDataSourceProperties dynamicDataSourceProperties;

    public DynamicDatasourceConfig(HussarDynamicProperties hussarDynamicProperties, DynamicMasterDatasourceProperties dynamicMasterDatasourceProperties, DynamicDataSourceProperties dynamicDataSourceProperties) {
        this.hussarDynamicProperties = hussarDynamicProperties;
        this.dynamicMasterDatasourceProperties = dynamicMasterDatasourceProperties;
        this.dynamicDataSourceProperties = dynamicDataSourceProperties;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.datasource.dynamic.datasource.master", name={"jdbc-from-ds"}, havingValue="true", matchIfMissing=false)
    public DynamicDataSourceProvider jdbcDynamicDataSourceProvider(DynamicMasterDatasourceProperties dynamicMasterDatasourceProperties, DynamicDataSourceProperties dynamicDataSourceProperties) {
        return new JdbcDynamicDataSourceProvider(dynamicMasterDatasourceProperties, dynamicDataSourceProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public HeaderDatasourceKey headerDatasourceKey() {
        return new DefaultHeaderDatasourceKeyProcesser();
    }

    @Bean
    public DsProcessor dsProcessor(BeanFactory beanFactory, HeaderDatasourceKey headerDatasourceKey) {
        DynamicDsTokenProcessor dsTokenProcessor = new DynamicDsTokenProcessor(this.hussarDynamicProperties, headerDatasourceKey);
        DsSpelExpressionProcessor spelExpressionProcessor = new DsSpelExpressionProcessor();
        spelExpressionProcessor.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        dsTokenProcessor.setNextProcessor((DsProcessor)spelExpressionProcessor);
        return dsTokenProcessor;
    }

    @Bean
    public DynamicDatasourceService defaultDynamicDatasourceService() {
        return new DefaultDynamicDatasourceService();
    }

    @Bean
    public DynamicDatasourceAutoSwitchAdvisor dynamicDatasourceAutoSwitchAdvisor(HussarDynamicProperties dynamicProperties, HeaderDatasourceKey headerDatasourceKey) {
        DynamicDataSourceAutoSwitchInterceptor interceptor = new DynamicDataSourceAutoSwitchInterceptor(dynamicProperties, headerDatasourceKey);
        return new DynamicDatasourceAutoSwitchAdvisor(interceptor, Controller.class);
    }
}

