/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.datasource.config;

import com.jxdinfo.hussar.support.datasource.listener.SyncDynamicDataSourceListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

@Configuration
@ConditionalOnProperty(value={"hussar.cache.cache-type"}, havingValue="redis")
public class SyncDynamicDataSourceConfig {
    @Bean
    public SyncDynamicDataSourceListener syncDynamicDataSourceListener() {
        return new SyncDynamicDataSourceListener();
    }

    @Bean
    public RedisMessageListenerContainer syncDsRedisContainer(RedisConnectionFactory redisConnectionFactory, SyncDynamicDataSourceListener listener) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(redisConnectionFactory);
        container.addMessageListener((MessageListener)listener, (Topic)new ChannelTopic("sync_dynamic_datasource_channel"));
        return container;
    }
}

