/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.datasource.util;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.ReflectUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.support.service.dto.DynamicDataSourceDto;
import java.lang.reflect.Field;
import java.util.Map;

public class DynamicDatasourceUtils {
    public static DataSourceProperty createDatasourceProperty(DynamicDataSourceProperties properties, DynamicDataSourceDto dynamicDataSourceDto) {
        DataSourceProperty dataSourceProperty = new DataSourceProperty();
        if (HussarUtils.isNotEmpty((Object)properties)) {
            DruidConfig druidConfig = null;
            druidConfig = properties.getDruid();
            if (HussarUtils.isNotEmpty((Object)druidConfig)) {
                DruidConfig config1 = (DruidConfig)BeanUtil.copy((Object)druidConfig, DruidConfig.class);
                dataSourceProperty.setDruid(config1);
            }
        }
        dataSourceProperty.setUsername(dynamicDataSourceDto.getUserName());
        dataSourceProperty.setPassword(dynamicDataSourceDto.getPassword());
        dataSourceProperty.setUrl(dynamicDataSourceDto.getUrl());
        dataSourceProperty.setDriverClassName(dynamicDataSourceDto.getDriverClassName());
        dataSourceProperty.setPoolName(dynamicDataSourceDto.getPoolName());
        DruidConfig druidconfig = dataSourceProperty.getDruid();
        BeanUtil.copyNonNull((Object)dynamicDataSourceDto.getDruidConfig(), (Object)druidconfig);
        return dataSourceProperty;
    }

    public static DynamicDataSourceDto createDynamicDatasourceDto(DruidDataSource dataSource, String pollName) {
        DynamicDataSourceDto dto = new DynamicDataSourceDto();
        if (HussarUtils.isEmpty((Object)dataSource)) {
            return dto;
        }
        dto.setPoolName(pollName);
        dto.setUserName(dataSource.getUsername());
        dto.setPassword(dataSource.getPassword());
        dto.setUrl(dataSource.getUrl());
        dto.setDriverClassName(dataSource.getDriverClassName());
        DruidConfig druidconfig = new DruidConfig();
        BeanUtil.copyNonNull((Object)dataSource, (Object)druidconfig);
        dto.setDruidConfig(druidconfig);
        return dto;
    }

    public static <T> T mapToBeanWithNoCase(Map<String, Object> beanMap, Class<T> valueType) {
        Object to = ReflectUtil.newInstance(valueType, (Object[])new Object[0]);
        if (beanMap.isEmpty()) {
            return (T)to;
        }
        Field[] fields = valueType.getDeclaredFields();
        for (Map.Entry<String, Object> entry : beanMap.entrySet()) {
            String mapKey = entry.getKey();
            for (Field prop : fields) {
                if (!prop.getName().equalsIgnoreCase(mapKey)) continue;
                BeanUtil.setProperty((Object)to, (String)prop.getName(), (Object)entry.getValue());
            }
        }
        return (T)to;
    }

    public static DruidConfig createDataSourceDruid(DynamicDataSourceProperties properties, String druidJson) {
        DruidConfig druidConfig = new DruidConfig();
        if (HussarUtils.isNotEmpty((Object)properties)) {
            druidConfig = properties.getDruid();
        }
        Map map = JsonUtil.readMap((String)druidJson, String.class, Object.class);
        Field[] fields = DruidConfig.class.getDeclaredFields();
        block0: for (Map.Entry entry : map.entrySet()) {
            String mapKey = StringUtil.lineToHump((String)((String)entry.getKey()));
            for (Field prop : fields) {
                if (!prop.getName().equalsIgnoreCase(mapKey)) continue;
                BeanUtil.setProperty((Object)druidConfig, (String)prop.getName(), entry.getValue());
                continue block0;
            }
        }
        return druidConfig;
    }
}

