/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.datasource.support.service.impl;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.creator.DefaultDataSourceCreator;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.HussarDataSourceExceptionMessage;
import com.jxdinfo.hussar.support.datasource.exception.DynamicDatasourceException;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.datasource.support.service.dto.DynamicDataSourceDto;
import com.jxdinfo.hussar.support.datasource.util.DynamicDatasourceUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultDynamicDatasourceService
implements DynamicDatasourceService {
    @Autowired
    private DataSource dataSource;
    @Autowired
    private DefaultDataSourceCreator dataSourceCreator;
    @Autowired
    private DynamicDataSourceProperties properties;

    @Override
    public void addDynamicDatasource(DynamicDataSourceDto dynamicDataSourceDto) {
        DynamicDatasourceException.throwBy(HussarUtils.isEmpty((Object)dynamicDataSourceDto), HussarDataSourceExceptionMessage.DATA_SOURCE_IS_EMPTY_ADD_FAILED.getDesc());
        DynamicDatasourceException.throwBy(HussarUtils.isEmpty((Object)dynamicDataSourceDto.getPoolName()), HussarDataSourceExceptionMessage.DATA_SOURCE_NAME_IS_EMPTY_ADD_FAILED.getDesc());
        DynamicDatasourceException.throwBy(HussarUtils.isEmpty((Object)dynamicDataSourceDto.getUserName()), HussarDataSourceExceptionMessage.DATA_SOURCE_USER_NAME_IS_EMPTY_ADD_FAILED.getDesc());
        DynamicDatasourceException.throwBy(HussarUtils.isEmpty((Object)dynamicDataSourceDto.getPassword()), HussarDataSourceExceptionMessage.DATA_SOURCE_PASSWORD_IS_EMPTY_ADD_FAILED.getDesc());
        DynamicDatasourceException.throwBy(HussarUtils.isEmpty((Object)dynamicDataSourceDto.getUrl()), HussarDataSourceExceptionMessage.DATA_SOURCE_URL_IS_EMPTY_ADD_FAILED.getDesc());
        DynamicDatasourceException.throwBy(HussarUtils.isEmpty((Object)dynamicDataSourceDto.getDriverClassName()), HussarDataSourceExceptionMessage.DATA_SOURCE_DRIVER_IS_EMPTY_ADD_FAILED.getDesc());
        DataSourceProperty datasourceProperty = DynamicDatasourceUtils.createDatasourceProperty(this.properties, dynamicDataSourceDto);
        DataSource newDataSource = this.dataSourceCreator.createDataSource(datasourceProperty);
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        ds.addDataSource(dynamicDataSourceDto.getPoolName(), newDataSource);
    }

    @Override
    public void removeDynamicDatasource(String name) {
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        ds.removeDataSource(name);
    }

    @Override
    public Set<String> getAllDatasourcesName() {
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        Map dataSources = ds.getDataSources();
        if (HussarUtils.isNotEmpty((Object)dataSources)) {
            return ds.getDataSources().keySet();
        }
        return null;
    }

    @Override
    public String getCurrentDatasourceName() {
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        DataSource dataSource = ds.determineDataSource();
        if (HussarUtils.isEmpty((Object)dataSource)) {
            return null;
        }
        ItemDataSource itemDataSource = null;
        String currentName = null;
        try {
            itemDataSource = (ItemDataSource)dataSource;
            currentName = itemDataSource.getName();
        }
        catch (Exception e) {
            throw new DynamicDatasourceException(HussarDataSourceExceptionMessage.DATA_SOURCE_NAME_IS_EMPTY.getDesc());
        }
        return currentName;
    }

    @Override
    public ItemDataSource getCurrentDatasource() {
        ItemDataSource itemDataSource;
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        DataSource dataSource = ds.determineDataSource();
        if (HussarUtils.isEmpty((Object)dataSource)) {
            return null;
        }
        try {
            itemDataSource = (ItemDataSource)dataSource;
        }
        catch (Exception e) {
            throw new DynamicDatasourceException(HussarDataSourceExceptionMessage.DATA_SOURCE_IS_EMPTY.getDesc());
        }
        return itemDataSource;
    }

    @Override
    public ItemDataSource getDatasourceByPoolName(String name) {
        ItemDataSource itemDataSource;
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        DataSource dataSource = ds.getDataSource(name);
        try {
            itemDataSource = (ItemDataSource)dataSource;
        }
        catch (Exception e) {
            throw new DynamicDatasourceException(HussarDataSourceExceptionMessage.DATA_SOURCE_IS_EMPTY.getDesc());
        }
        return itemDataSource;
    }

    @Override
    public List<ItemDataSource> getAllDatasources() {
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        Map dataSources = ds.getDataSources();
        if (HussarUtils.isNotEmpty((Object)dataSources)) {
            List hussarItemDataSources = ds.getDataSources().entrySet().stream().map(entry -> {
                if (entry.getValue() instanceof ItemDataSource) {
                    return (ItemDataSource)entry.getValue();
                }
                return null;
            }).collect(Collectors.toList());
            List<ItemDataSource> collect = hussarItemDataSources.stream().filter(idatasource -> HussarUtils.isNotEmpty((Object)idatasource)).collect(Collectors.toList());
            return collect;
        }
        return null;
    }
}

