/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.datasource.support;

import com.baomidou.dynamic.datasource.provider.AbstractJdbcDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.properties.DynamicMasterDatasourceProperties;
import com.jxdinfo.hussar.support.datasource.support.service.dto.DynamicDataSourceDto;
import com.jxdinfo.hussar.support.datasource.util.DynamicDatasourceUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDynamicDataSourceProvider
extends AbstractJdbcDataSourceProvider {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private DynamicMasterDatasourceProperties dynamicMasterDatasourceProperties;
    private DynamicDataSourceProperties dynamicDataSourceProperties;

    public JdbcDynamicDataSourceProvider(String url, String username, String password) {
        super(url, username, password);
    }

    public JdbcDynamicDataSourceProvider(String driveName, String url, String username, String password) {
        super(driveName, url, username, password);
    }

    public JdbcDynamicDataSourceProvider(DynamicMasterDatasourceProperties dynamicMasterDatasourceProperties) {
        this(dynamicMasterDatasourceProperties.getUrl(), dynamicMasterDatasourceProperties.getUsername(), dynamicMasterDatasourceProperties.getPassword());
        this.dynamicMasterDatasourceProperties = dynamicMasterDatasourceProperties;
    }

    public JdbcDynamicDataSourceProvider(DynamicMasterDatasourceProperties dynamicMasterDatasourceProperties, DynamicDataSourceProperties dynamicDataSourceProperties) {
        this(dynamicMasterDatasourceProperties.getDriverClassName(), dynamicMasterDatasourceProperties.getUrl(), dynamicMasterDatasourceProperties.getUsername(), dynamicMasterDatasourceProperties.getPassword());
        this.dynamicMasterDatasourceProperties = dynamicMasterDatasourceProperties;
        this.dynamicDataSourceProperties = dynamicDataSourceProperties;
    }

    protected Map<String, DataSourceProperty> executeStmt(Statement statement) throws SQLException {
        this.logger.info("\u83b7\u53d6\u4e3b\u5e93\u6240\u6709\u6570\u636e\u6e90\u7684sql:[{}]", (Object)this.dynamicMasterDatasourceProperties.getSelectDatasourceSql());
        ResultSet rs = statement.executeQuery(this.dynamicMasterDatasourceProperties.getSelectDatasourceSql());
        HashMap<String, DataSourceProperty> map = new HashMap<String, DataSourceProperty>();
        HashMap<String, Object> resultEntityMap = null;
        PreparedStatement preparedStatement = null;
        while (rs.next()) {
            ResultSetMetaData metaData = rs.getMetaData();
            if (HussarUtils.isEmpty((Object)metaData) || metaData.getColumnCount() <= 0) {
                return map;
            }
            resultEntityMap = new HashMap<String, Object>();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                resultEntityMap.put(metaData.getColumnLabel(i), rs.getObject(metaData.getColumnLabel(i)));
            }
            DynamicDataSourceDto dynamicDataSourceDto = DynamicDatasourceUtils.mapToBeanWithNoCase(resultEntityMap, DynamicDataSourceDto.class);
            if (HussarUtils.isEmpty((Object)dynamicDataSourceDto) || HussarUtils.isEmpty((Object)dynamicDataSourceDto.getPoolName()) || HussarUtils.isEmpty((Object)dynamicDataSourceDto.getDriverClassName()) || HussarUtils.isEmpty((Object)dynamicDataSourceDto.getUrl()) || HussarUtils.isEmpty((Object)dynamicDataSourceDto.getUserName()) || HussarUtils.isEmpty((Object)dynamicDataSourceDto.getPassword())) {
                this.logger.error("name-username-password-url-driver \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u52a0\u8f7d\u6570\u636e\u6e90\u4fe1\u606f");
                continue;
            }
            preparedStatement = statement.getConnection().prepareStatement(this.dynamicMasterDatasourceProperties.getSelectDatasourceConfigSql());
            preparedStatement.setString(1, dynamicDataSourceDto.getPoolName());
            ResultSet resultSet = preparedStatement.executeQuery();
            String parameterValue = null;
            while (resultSet.next()) {
                metaData = resultSet.getMetaData();
                if (HussarUtils.isEmpty((Object)metaData) || metaData.getColumnCount() <= 0) continue;
                parameterValue = resultSet.getString(metaData.getColumnLabel(1));
            }
            preparedStatement.close();
            if (HussarUtils.isNotEmpty(parameterValue)) {
                DruidConfig druidConfig = DynamicDatasourceUtils.createDataSourceDruid(this.dynamicDataSourceProperties, parameterValue);
                dynamicDataSourceDto.setDruidConfig(druidConfig);
            }
            DataSourceProperty datasourceProperty = DynamicDatasourceUtils.createDatasourceProperty(this.dynamicDataSourceProperties, dynamicDataSourceDto);
            map.put(dynamicDataSourceDto.getPoolName(), datasourceProperty);
            this.logger.info("\u83b7\u53d6\u7684\u6570\u636e\u6e90\u540d\u79f0{}\uff0c\u6570\u636e\u6e90\u7528\u6237\u540d\uff1a{}\uff0c\u6570\u636e\u6e90url:{}", new Object[]{dynamicDataSourceDto.getPoolName(), dynamicDataSourceDto.getUserName(), dynamicDataSourceDto.getUrl()});
        }
        return map;
    }
}

