/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.datasource.aop;

import com.baomidou.dynamic.datasource.annotation.DS;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;

public class DynamicDatasourceAutoSwitchAdvisor
extends AbstractPointcutAdvisor
implements BeanFactoryAware {
    private final Advice advice;
    private final Pointcut pointcut;
    private final Class<? extends Annotation> annotation;

    public DynamicDatasourceAutoSwitchAdvisor(@NonNull MethodInterceptor advice, @NonNull Class<? extends Annotation> annotation) {
        this.advice = advice;
        this.annotation = annotation;
        this.pointcut = this.buildPointcut();
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    private Pointcut buildPointcut() {
        CustomClassFilter cpc = new CustomClassFilter(this.annotation);
        return new ComposablePointcut((ClassFilter)cpc);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.advice instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.advice).setBeanFactory(beanFactory);
        }
    }

    private static class CustomClassFilter
    implements ClassFilter {
        private final Class<? extends Annotation> annotation;

        public CustomClassFilter(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        public boolean matches(Class<?> targetClass) {
            if (Proxy.isProxyClass(targetClass)) {
                return false;
            }
            return this.matchClass(targetClass);
        }

        private boolean matchClass(Class<?> targetClass) {
            return AnnotatedElementUtils.hasAnnotation(targetClass, this.annotation) && !AnnotatedElementUtils.hasAnnotation(targetClass, DS.class);
        }
    }
}

