/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.datasource.util;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.support.service.dto.DynamicDataSourceDto;
import java.lang.reflect.Field;
import java.util.Map;

public class DynamicDatasourceUtils {
    public static DataSourceProperty createDatasourceProperty(DynamicDataSourceProperties properties, DynamicDataSourceDto dynamicDataSourceDto) {
        DataSourceProperty dataSourceProperty = new DataSourceProperty();
        DruidConfig config = dataSourceProperty.getDruid();
        if (HussarUtils.isNotEmpty((Object)properties)) {
            DruidConfig druidConfig = null;
            druidConfig = properties.getDruid();
            if (HussarUtils.isNotEmpty((Object)druidConfig)) {
                HussarUtils.copy((Object)druidConfig, (Object)config);
            }
        }
        dataSourceProperty.setUsername(dynamicDataSourceDto.getUserName());
        dataSourceProperty.setPassword(dynamicDataSourceDto.getPassword());
        dataSourceProperty.setUrl(dynamicDataSourceDto.getUrl());
        dataSourceProperty.setDriverClassName(dynamicDataSourceDto.getDriverClassName());
        dataSourceProperty.setPoolName(dynamicDataSourceDto.getPoolName());
        DruidConfig druid = dataSourceProperty.getDruid();
        if (HussarUtils.isNotEmpty((Object)dynamicDataSourceDto.getInitialSize()) && dynamicDataSourceDto.getInitialSize() > 0) {
            druid.setInitialSize(dynamicDataSourceDto.getInitialSize());
        }
        if (HussarUtils.isNotEmpty((Object)dynamicDataSourceDto.getMaxActive()) && dynamicDataSourceDto.getMaxActive() > 0) {
            druid.setMaxActive(dynamicDataSourceDto.getMaxActive());
        }
        if (HussarUtils.isNotEmpty((Object)dynamicDataSourceDto.getMinIdle()) && dynamicDataSourceDto.getMinIdle() > 0) {
            druid.setMinIdle(dynamicDataSourceDto.getMinIdle());
        }
        if (HussarUtils.isNotEmpty((Object)dynamicDataSourceDto.getMaxWait()) && dynamicDataSourceDto.getMaxWait() > 0) {
            druid.setMaxActive(dynamicDataSourceDto.getMaxWait());
        }
        return dataSourceProperty;
    }

    public static DynamicDataSourceDto createDynamicDatasourceDto(DruidDataSource dataSource, String pollName) {
        DynamicDataSourceDto dto = new DynamicDataSourceDto();
        if (HussarUtils.isEmpty((Object)dataSource)) {
            return dto;
        }
        dto.setPoolName(pollName);
        dto.setUserName(dataSource.getUsername());
        dto.setPassword(dataSource.getPassword());
        dto.setUrl(dataSource.getUrl());
        dto.setDriverClassName(dataSource.getDriverClassName());
        dto.setMinIdle(dataSource.getMinIdle());
        dto.setMaxWait(Integer.parseInt(dataSource.getMaxWait() + ""));
        dto.setInitialSize(dataSource.getInitialSize());
        dto.setMaxActive(dataSource.getMaxActive());
        return dto;
    }

    public static <T> T mapToBeanWithNoCase(Map<String, Object> beanMap, Class<T> valueType) {
        Object to = BeanUtil.newInstance(valueType);
        if (beanMap.isEmpty()) {
            return (T)to;
        }
        Field[] fields = valueType.getDeclaredFields();
        for (Map.Entry<String, Object> entry : beanMap.entrySet()) {
            String mapKey = entry.getKey();
            for (Field prop : fields) {
                if (!prop.getName().equalsIgnoreCase(mapKey)) continue;
                BeanUtil.setProperty((Object)to, (String)prop.getName(), (Object)entry.getValue());
            }
        }
        return (T)to;
    }
}

