/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.redis;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.data.redis.cache.BatchStrategies;
import org.springframework.data.redis.cache.BatchStrategy;
import org.springframework.data.redis.cache.CacheStatistics;
import org.springframework.data.redis.cache.CacheStatisticsCollector;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyScanOptions;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HussarSpringRedisCacheWriter
implements RedisCacheWriter {
    private final RedisConnectionFactory connectionFactory;
    private final Duration sleepTime;
    private final CacheStatisticsCollector statistics;
    private final BatchStrategy batchStrategy;

    public HussarSpringRedisCacheWriter(RedisConnectionFactory connectionFactory) {
        this(connectionFactory, BatchStrategies.keys());
    }

    public HussarSpringRedisCacheWriter(RedisConnectionFactory connectionFactory, BatchStrategy batchStrategy) {
        this(connectionFactory, Duration.ZERO, batchStrategy);
    }

    public HussarSpringRedisCacheWriter(RedisConnectionFactory connectionFactory, Duration sleepTime, BatchStrategy batchStrategy) {
        this(connectionFactory, sleepTime, CacheStatisticsCollector.none(), batchStrategy);
    }

    public HussarSpringRedisCacheWriter(RedisConnectionFactory connectionFactory, Duration sleepTime, CacheStatisticsCollector cacheStatisticsCollector, BatchStrategy batchStrategy) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        Assert.notNull((Object)sleepTime, (String)"SleepTime must not be null!");
        Assert.notNull((Object)cacheStatisticsCollector, (String)"CacheStatisticsCollector must not be null!");
        Assert.notNull((Object)batchStrategy, (String)"BatchStrategy must not be null!");
        this.connectionFactory = connectionFactory;
        this.sleepTime = sleepTime;
        this.statistics = cacheStatisticsCollector;
        this.batchStrategy = batchStrategy;
    }

    public void put(String name, byte[] key, byte[] value, @Nullable Duration ttl) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        this.execute(name, connection -> {
            if (HussarSpringRedisCacheWriter.shouldExpireWithin(ttl)) {
                connection.set(key, value, Expiration.from((long)ttl.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS), RedisStringCommands.SetOption.upsert());
            } else {
                connection.set(key, value);
            }
            return "OK";
        });
        this.statistics.incPuts(name);
    }

    public byte[] get(String name, byte[] key) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        byte[] result = this.execute(name, connection -> connection.get(key));
        this.statistics.incGets(name);
        if (result != null) {
            this.statistics.incHits(name);
        } else {
            this.statistics.incMisses(name);
        }
        return result;
    }

    public byte[] putIfAbsent(String name, byte[] key, byte[] value, @Nullable Duration ttl) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.execute(name, connection -> {
            if (this.isLockingCacheWriter()) {
                this.doLock(name, (RedisConnection)connection);
            }
            try {
                boolean put = HussarSpringRedisCacheWriter.shouldExpireWithin(ttl) ? connection.set(key, value, Expiration.from((Duration)ttl), RedisStringCommands.SetOption.ifAbsent()).booleanValue() : connection.setNX(key, value).booleanValue();
                if (put) {
                    this.statistics.incPuts(name);
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] byArray = connection.get(key);
                return byArray;
            }
            finally {
                if (this.isLockingCacheWriter()) {
                    this.doUnlock(name, (RedisConnection)connection);
                }
            }
        });
    }

    public void remove(String name, byte[] key) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        this.execute(name, connection -> connection.del((byte[][])new byte[][]{key}));
        this.statistics.incDeletes(name);
    }

    public void clean(String name, byte[] pattern) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        this.execute(name, connection -> {
            boolean wasLocked = false;
            try {
                long deleteCount;
                if (this.isLockingCacheWriter()) {
                    this.doLock(name, (RedisConnection)connection);
                    wasLocked = true;
                }
                for (deleteCount = this.batchStrategy.cleanCache(connection, name, pattern); deleteCount > Integer.MAX_VALUE; deleteCount -= Integer.MAX_VALUE) {
                    this.statistics.incDeletesBy(name, Integer.MAX_VALUE);
                }
                this.statistics.incDeletesBy(name, (int)deleteCount);
            }
            finally {
                if (wasLocked && this.isLockingCacheWriter()) {
                    this.doUnlock(name, (RedisConnection)connection);
                }
            }
            return "OK";
        });
    }

    public CacheStatistics getCacheStatistics(String cacheName) {
        return this.statistics.getCacheStatistics(cacheName);
    }

    public void clearStatistics(String name) {
        this.statistics.reset(name);
    }

    public RedisCacheWriter withStatisticsCollector(CacheStatisticsCollector cacheStatisticsCollector) {
        return new HussarSpringRedisCacheWriter(this.connectionFactory, this.sleepTime, cacheStatisticsCollector, this.batchStrategy);
    }

    void lock(String name) {
        this.execute(name, connection -> this.doLock(name, (RedisConnection)connection));
    }

    void unlock(String name) {
        this.executeLockFree(connection -> this.doUnlock(name, (RedisConnection)connection));
    }

    protected Boolean doLock(String name, RedisConnection connection) {
        return connection.setNX(HussarSpringRedisCacheWriter.createCacheLockKey(name), new byte[0]);
    }

    protected Long doUnlock(String name, RedisConnection connection) {
        return connection.del((byte[][])new byte[][]{HussarSpringRedisCacheWriter.createCacheLockKey(name)});
    }

    boolean doCheckLock(String name, RedisConnection connection) {
        return connection.exists(HussarSpringRedisCacheWriter.createCacheLockKey(name));
    }

    protected boolean isLockingCacheWriter() {
        return !this.sleepTime.isZero() && !this.sleepTime.isNegative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(String name, Function<RedisConnection, T> callback) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            this.checkAndPotentiallyWaitUntilUnlocked(name, connection);
            T t = callback.apply(connection);
            return t;
        }
    }

    public void executeLockFree(Consumer<RedisConnection> callback) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            callback.accept(connection);
        }
    }

    private void checkAndPotentiallyWaitUntilUnlocked(String name, RedisConnection connection) {
        if (!this.isLockingCacheWriter()) {
            return;
        }
        long lockWaitTimeNs = System.nanoTime();
        try {
            while (this.doCheckLock(name, connection)) {
                Thread.sleep(this.sleepTime.toMillis());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new PessimisticLockingFailureException(String.format("Interrupted while waiting to unlock cache %s", name), (Throwable)ex);
        }
        finally {
            this.statistics.incLockTime(name, System.nanoTime() - lockWaitTimeNs);
        }
    }

    private static boolean shouldExpireWithin(@Nullable Duration ttl) {
        return ttl != null && !ttl.isZero() && !ttl.isNegative();
    }

    private static byte[] createCacheLockKey(String name) {
        return (name + "~lock").getBytes(StandardCharsets.UTF_8);
    }

    public boolean isClusterAware() {
        if (this.connectionFactory instanceof LettuceConnectionFactory) {
            LettuceConnectionFactory connectionFactory = (LettuceConnectionFactory)this.connectionFactory;
            return connectionFactory.isClusterAware();
        }
        return false;
    }

    public boolean isRedisSentinelAware() {
        if (this.connectionFactory instanceof LettuceConnectionFactory) {
            LettuceConnectionFactory connectionFactory = (LettuceConnectionFactory)this.connectionFactory;
            return connectionFactory.isRedisSentinelAware();
        }
        return false;
    }

    public void putSet(String name, byte[] key, byte[][] values, Duration ttl) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Value must not be null!");
        this.execute(name, connection -> {
            if (HussarSpringRedisCacheWriter.shouldExpireWithin(ttl)) {
                connection.sAdd(key, values);
                connection.expire(key, ttl.getSeconds());
            } else {
                connection.sAdd(key, values);
            }
            return "OK";
        });
        this.statistics.incPuts(name);
    }

    public boolean containsValue(String name, byte[] key, byte[] value) {
        return this.execute(name, connection -> connection.sIsMember(key, value));
    }

    public List<Boolean> containsValues(String name, byte[] key, byte[][] values) {
        return this.execute(name, connection -> {
            connection.openPipeline();
            for (byte[] member : values) {
                connection.sIsMember(key, member);
            }
            List results = connection.closePipeline();
            ArrayList existsList = Lists.newArrayListWithCapacity((int)values.length);
            for (Object result : results) {
                existsList.add((Boolean)result);
            }
            return existsList;
        });
    }

    public Set<byte[]> getSet(String name, byte[] key) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Set result = this.execute(name, connection -> connection.sMembers(key));
        this.statistics.incGets(name);
        if (result != null && !result.isEmpty()) {
            this.statistics.incHits(name);
        } else {
            this.statistics.incMisses(name);
        }
        return result;
    }

    public void expire(String name, byte[] key, long seconds) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        this.execute(name, connection -> connection.expire(key, seconds));
    }

    public void putHash(String name, byte[] key, Map<byte[], byte[]> value, @Nullable Duration ttl) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(value, (String)"Value must not be null!");
        this.execute(name, connection -> {
            if (HussarSpringRedisCacheWriter.shouldExpireWithin(ttl)) {
                connection.hMSet(key, value);
                connection.expire(key, ttl.getSeconds());
            } else {
                connection.hMSet(key, value);
            }
            return "OK";
        });
        this.statistics.incPuts(name);
    }

    public Map<byte[], byte[]> getHash(String name, byte[] key) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Map result = this.execute(name, connection -> connection.hGetAll(key));
        this.statistics.incGets(name);
        if (result != null) {
            this.statistics.incHits(name);
        } else {
            this.statistics.incMisses(name);
        }
        return result;
    }

    public byte[] getFieldValue(String name, byte[] key, byte[] field) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        byte[] result = this.execute(name, connection -> connection.hGet(key, field));
        this.statistics.incGets(name);
        if (result != null) {
            this.statistics.incHits(name);
        } else {
            this.statistics.incMisses(name);
        }
        return result;
    }

    public void putList(String name, byte[] key, byte[][] value, @Nullable Duration ttl) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        this.execute(name, connection -> {
            if (HussarSpringRedisCacheWriter.shouldExpireWithin(ttl)) {
                connection.lPush(key, value);
                connection.expire(key, ttl.getSeconds());
            } else {
                connection.lPush(key, value);
            }
            return "OK";
        });
        this.statistics.incPuts(name);
    }

    public List<byte[]> getList(String name, byte[] key) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        List result = this.execute(name, connection -> connection.lRange(key, 0L, -1L));
        this.statistics.incGets(name);
        if (result != null) {
            this.statistics.incHits(name);
        } else {
            this.statistics.incMisses(name);
        }
        return result;
    }

    public void addField(String name, byte[] key, byte[] field, byte[] value) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        this.execute(name, connection -> connection.hSet(key, field, value));
    }

    public void removeField(String name, byte[] key, byte[] field) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        this.execute(name, connection -> connection.hDel(key, (byte[][])new byte[][]{field}));
    }

    public void updateKeyTimeout(String name, byte[] key, long seconds) {
        this.execute(name, connection -> connection.expire(key, seconds));
    }

    public List<byte[]> getHashValsWithKeys(String name, String keyPattern) {
        ArrayList result = Lists.newArrayList();
        ScanOptions options = KeyScanOptions.scanOptions((DataType)DataType.HASH).count(1000L).match(keyPattern).build();
        try (Cursor cursor = this.execute(name, connection -> connection.scan(options));){
            while (cursor.hasNext()) {
                List vals = this.execute(name, connection -> connection.hVals((byte[])cursor.next()));
                if (!HussarUtils.isNotEmpty((Object)vals)) continue;
                result.addAll(vals);
            }
        }
        return result;
    }
}

