/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.redis;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class HussarRedisTemplate<K, V>
extends RedisTemplate<K, V> {
    private boolean initialized = false;
    private boolean enableTransactionSupport = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(@NonNull RedisCallback<T> action, boolean exposeConnection, boolean pipeline) {
        Assert.isTrue((boolean)this.initialized, (String)"template not initialized; call afterPropertiesSet() before using it");
        Assert.notNull(action, (String)"Callback object must not be null");
        RedisConnectionFactory factory = this.getRequiredConnectionFactory();
        RedisConnection conn = RedisConnectionUtils.getConnection((RedisConnectionFactory)factory, (boolean)this.enableTransactionSupport);
        try {
            boolean existingConnection = TransactionSynchronizationManager.hasResource((Object)factory);
            RedisConnection connToUse = this.preProcessConnection(conn, existingConnection);
            boolean pipelineStatus = connToUse.isPipelined();
            if (pipeline && !pipelineStatus) {
                this.openPipeline(connToUse);
            }
            RedisConnection connToExpose = exposeConnection ? connToUse : this.createRedisConnectionProxy(connToUse);
            Object result = action.doInRedis(connToExpose);
            if (pipeline && !pipelineStatus) {
                this.closePipeline(connToUse);
            }
            Object object = this.postProcessResult(result, connToUse, existingConnection);
            return (T)object;
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)conn, (RedisConnectionFactory)factory, (boolean)this.enableTransactionSupport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<Object> executePipelined(@NonNull SessionCallback<?> session, RedisSerializer<?> resultSerializer) {
        Assert.isTrue((boolean)this.initialized, (String)"template not initialized; call afterPropertiesSet() before using it");
        Assert.notNull(session, (String)"Callback object must not be null");
        RedisConnectionFactory factory = this.getRequiredConnectionFactory();
        RedisConnectionUtils.bindConnection((RedisConnectionFactory)factory, (boolean)this.enableTransactionSupport);
        try {
            List list = (List)this.execute(connection -> {
                this.openPipeline(connection);
                boolean pipelinedClosed = false;
                try {
                    Object result = this.executeSession(session);
                    if (result != null) {
                        throw new InvalidDataAccessApiUsageException("Callback cannot return a non-null value as it gets overwritten by the pipeline");
                    }
                    List<Object> closePipeline = this.closePipeline(connection);
                    pipelinedClosed = true;
                    List<Object> list = this.deserializeMixedResults(closePipeline, resultSerializer, this.getHashKeySerializer(), this.getHashValueSerializer());
                    return list;
                }
                finally {
                    if (!pipelinedClosed) {
                        this.closePipeline(connection);
                    }
                }
            }, true);
            return list;
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)factory);
        }
    }

    @NonNull
    public List<Object> executePipelined(@NonNull RedisCallback<?> action, @Nullable RedisSerializer<?> resultSerializer) {
        return (List)this.execute(connection -> {
            this.openPipeline(connection);
            boolean pipelinedClosed = false;
            try {
                RedisConnection connToExpose = this.isExposeConnection() ? connection : this.createRedisConnectionProxy(connection);
                Object result = action.doInRedis(connToExpose);
                if (result != null) {
                    throw new InvalidDataAccessApiUsageException("Callback cannot return a non-null value as it gets overwritten by the pipeline");
                }
                List<Object> closePipeline = this.closePipeline(connection);
                pipelinedClosed = true;
                List<Object> list = this.deserializeMixedResults(closePipeline, resultSerializer, this.getHashKeySerializer(), this.getHashValueSerializer());
                return list;
            }
            finally {
                if (!pipelinedClosed) {
                    this.closePipeline(connection);
                }
            }
        }, true);
    }

    private void openPipeline(RedisConnection connection) {
        if (connection instanceof LettuceConnection) {
            ((LettuceConnection)connection).setPipeliningFlushPolicy(LettuceConnection.PipeliningFlushPolicy.flushOnClose());
        }
        connection.openPipeline();
    }

    private List<Object> closePipeline(RedisConnection connection) {
        List results = connection.closePipeline();
        if (connection instanceof LettuceConnection) {
            ((LettuceConnection)connection).setPipeliningFlushPolicy(LettuceConnection.PipeliningFlushPolicy.flushEachCommand());
        }
        return results;
    }

    private Object executeSession(SessionCallback<?> session) {
        return session.execute((RedisOperations)this);
    }

    @Nullable
    private List<Object> deserializeMixedResults(@Nullable List<Object> rawValues, @Nullable RedisSerializer valueSerializer, @Nullable RedisSerializer hashKeySerializer, @Nullable RedisSerializer hashValueSerializer) {
        if (rawValues == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object rawValue : rawValues) {
            if (rawValue instanceof byte[] && valueSerializer != null) {
                values.add(valueSerializer.deserialize((byte[])rawValue));
                continue;
            }
            if (rawValue instanceof List) {
                values.add(this.deserializeMixedResults((List)rawValue, valueSerializer, hashKeySerializer, hashValueSerializer));
                continue;
            }
            if (rawValue instanceof Set && !((Set)rawValue).isEmpty()) {
                values.add(this.deserializeSet((Set)rawValue, valueSerializer));
                continue;
            }
            if (rawValue instanceof Map && !((Map)rawValue).isEmpty() && ((Map)rawValue).values().iterator().next() instanceof byte[]) {
                values.add(SerializationUtils.deserialize((Map)((Map)rawValue), (RedisSerializer)hashKeySerializer, (RedisSerializer)hashValueSerializer));
                continue;
            }
            values.add(rawValue);
        }
        return values;
    }

    private Set<?> deserializeSet(Set rawSet, @Nullable RedisSerializer valueSerializer) {
        if (rawSet.isEmpty()) {
            return rawSet;
        }
        Object setValue = rawSet.iterator().next();
        if (setValue instanceof byte[] && valueSerializer != null) {
            return SerializationUtils.deserialize((Set)rawSet, (RedisSerializer)valueSerializer);
        }
        if (setValue instanceof RedisZSetCommands.Tuple) {
            return this.convertTupleValues(rawSet, valueSerializer);
        }
        return rawSet;
    }

    private Set<ZSetOperations.TypedTuple<V>> convertTupleValues(Set<RedisZSetCommands.Tuple> rawValues, @Nullable RedisSerializer valueSerializer) {
        LinkedHashSet<ZSetOperations.TypedTuple<V>> set = new LinkedHashSet<ZSetOperations.TypedTuple<V>>(rawValues.size());
        for (RedisZSetCommands.Tuple rawValue : rawValues) {
            Object value = rawValue.getValue();
            if (valueSerializer != null) {
                value = valueSerializer.deserialize(rawValue.getValue());
            }
            set.add((ZSetOperations.TypedTuple<V>)new DefaultTypedTuple(value, rawValue.getScore()));
        }
        return set;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.initialized = true;
    }

    public void setEnableTransactionSupport(boolean enableTransactionSupport) {
        this.enableTransactionSupport = enableTransactionSupport;
        super.setEnableTransactionSupport(enableTransactionSupport);
    }
}

