/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.ehcache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.support.HussarCache;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Query;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;

public class HussarEhcacheCache
extends EhCacheCache
implements HussarCache {
    private final Ehcache ehcache;

    public HussarEhcacheCache(EhCacheCache ehcache) {
        super(ehcache.getNativeCache());
        this.ehcache = ehcache.getNativeCache();
    }

    public Ehcache getHussarCache() {
        return this.ehcache;
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value) {
        Cache.ValueWrapper existingValue = this.get(key);
        if (existingValue == null) {
            this.put(key, value, Duration.ZERO);
            existingValue = new SimpleValueWrapper(value);
        }
        return existingValue;
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value, Duration timeout) {
        Cache.ValueWrapper existingValue = this.get(key);
        if (existingValue == null) {
            this.put(key, value, timeout);
            existingValue = new SimpleValueWrapper(value);
        }
        return existingValue;
    }

    @Override
    public void put(Object key, Object value, Duration timeout) {
        Element element = new Element(key, value);
        element.setEternal(false);
        element.setTimeToLive(((Integer)NumberUtils.parseNumber((String)Long.toString(timeout.getSeconds()), Integer.class)).intValue());
        element.setTimeToIdle(((Integer)NumberUtils.parseNumber((String)Long.toString(timeout.getSeconds()), Integer.class)).intValue());
        this.ehcache.put(element);
    }

    @Override
    public void put(Object key, Object value, long seconds) {
        Duration timeoutDuration = null;
        timeoutDuration = seconds > 0L ? Duration.ofSeconds(seconds) : Duration.ZERO;
        this.put(key, value, timeoutDuration);
    }

    @Override
    public boolean containKey(Object key) {
        Element elementValue = this.ehcache.getQuiet(key);
        return elementValue != null;
    }

    @Override
    public List<String> getKeys(String key) {
        ArrayList<String> list = new ArrayList<String>();
        Results results = this.execKeyQueryLike(key);
        for (Result r : results.all()) {
            list.add(r.getKey().toString());
        }
        return list;
    }

    @Override
    public List<String> scanKeys(String key) {
        ArrayList<String> list = new ArrayList<String>();
        Results results = this.execKeyQueryLike(key);
        for (Result r : results.all()) {
            list.add(r.getKey().toString());
        }
        return list;
    }

    @Override
    public void evictKeys(String key) {
        Results results = this.execKeyQueryLike(key);
        for (Result r : results.all()) {
            this.ehcache.remove(r.getKey());
        }
    }

    @Override
    public Map<String, Object> getKeysAndValues(String key) {
        Results results = this.execKeyQueryLike(key);
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        for (Result r : results.all()) {
            tmp.put("value", r.getValue());
            tmp.put("key", r.getKey());
        }
        return tmp;
    }

    @Override
    public Long getKeyExpireTime(Object key) {
        Element element = this.ehcache.get(key);
        if (element == null) {
            return null;
        }
        long time = element.getExpirationTime();
        if (time == Long.MAX_VALUE) {
            return -1L;
        }
        return Duration.ofMillis(element.getExpirationTime() - System.currentTimeMillis()).getSeconds();
    }

    @Override
    public void putSet(Object key, Set<Object> value, long seconds) {
        if (CollectionUtils.isEmpty(value)) {
            return;
        }
        Map<Object, Boolean> mapValue = value.stream().collect(Collectors.toMap(k -> k, k -> Boolean.TRUE));
        this.putSet(key, mapValue, seconds);
    }

    @Override
    public void putSet(Object key, Map<Object, Boolean> value, long seconds) {
        if (CollectionUtils.isEmpty(value)) {
            return;
        }
        Map cacheValues = (Map)this.get(key, Map.class);
        if (CollectionUtils.isEmpty((Map)cacheValues)) {
            cacheValues = Maps.newHashMapWithExpectedSize((int)value.size());
        }
        cacheValues.putAll(value);
        this.put(key, (Object)cacheValues, seconds);
    }

    @Override
    public Boolean containsValue(Object key, Object value) {
        Map values = (Map)this.get(key, Map.class);
        if (null == values || values.isEmpty()) {
            return false;
        }
        return (Boolean)values.get(value);
    }

    @Override
    public Map<Object, Boolean> containsValues(Object key, List<Object> values) {
        Map cacheValues = (Map)this.get(key, Map.class);
        if (CollectionUtils.isEmpty((Map)cacheValues)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)values.size());
        for (Object value : values) {
            result.put(value, cacheValues.get(value));
        }
        return result;
    }

    @Override
    public Set<Object> getSet(Object key) {
        Map cacheValues = (Map)this.get(key, Map.class);
        if (CollectionUtils.isEmpty((Map)cacheValues)) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        return cacheValues.keySet().stream().filter(key1 -> cacheValues.getOrDefault(key1, Boolean.FALSE)).collect(Collectors.toSet());
    }

    @Override
    public void updateKeyTimeout(Object key, long timeout) {
        Cache.ValueWrapper valueWrapper = this.get(key);
        this.put(key, valueWrapper == null ? null : valueWrapper.get(), timeout);
    }

    @Override
    public void putHash(Object key, Map<Object, Object> value, long timeout) {
        this.put(key, value, timeout == -1L ? Long.MAX_VALUE : timeout);
    }

    @Override
    public Object getFieldValue(Object key, Object field) {
        Map value = (Map)this.get(key, Map.class);
        if (HussarUtils.isEmpty((Object)value)) {
            return null;
        }
        return value.getOrDefault(field, null);
    }

    @Override
    public void addField(Object key, Object field, Object value) {
        Map values = (Map)this.get(key, Map.class);
        if (HussarUtils.isEmpty((Object)values)) {
            return;
        }
        values.put(field, value);
        this.put(key, values);
    }

    @Override
    public Map<Object, Object> getHash(Object key) {
        return (Map)this.get(key, Map.class);
    }

    @Override
    public void removeField(Object key, Object field) {
        Map cacheValues = (Map)this.get(key, Map.class);
        cacheValues.remove(field);
        this.put(key, field, this.getKeyExpireTime(key));
    }

    @Override
    public List<Object> getHashValsWithKeyPattern(String keyPrefix) {
        List<String> keys = this.getKeys(keyPrefix);
        if (HussarUtils.isEmpty(keys)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList result = Lists.newArrayList();
        for (String key : keys) {
            Map<Object, Object> value = this.getHash(key);
            if (HussarUtils.isEmpty(value)) continue;
            result.addAll(value.values());
        }
        return result;
    }

    private Results execKeyQueryLike(String key) {
        Query query = this.ehcache.createQuery();
        query.includeKeys();
        query.includeValues();
        Attribute attribute = this.ehcache.getSearchAttribute("key");
        query.addCriteria(attribute.ilike("*" + key + "*"));
        Results results = query.execute();
        return results;
    }
}

