/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.config;

import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.config.EhCacheConfiguration;
import com.jxdinfo.hussar.support.cache.config.HussarRedisAutoConfiguration;
import com.jxdinfo.hussar.support.cache.support.CacheNameCreator;
import com.jxdinfo.hussar.support.cache.support.ehcache.SpringEhCacheCacheManager;
import com.jxdinfo.hussar.support.cache.support.multilevel.MultiLevelCacheManager;
import com.jxdinfo.hussar.support.cache.support.multilevel.messagenotify.DefaultCacheTenantInfoHandler;
import com.jxdinfo.hussar.support.cache.support.multilevel.messagenotify.DefaultSecondLevelCacheChangeNotify;
import com.jxdinfo.hussar.support.cache.support.multilevel.messagenotify.ICacheTenantInfoHandler;
import com.jxdinfo.hussar.support.cache.support.multilevel.messagenotify.ISecondLevelCacheChangeNotify;
import com.jxdinfo.hussar.support.cache.support.multilevel.messagenotify.SecondLevelCacheChangeListener;
import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import com.jxdinfo.hussar.support.cache.support.properties.HussarMultiLevelCacheProperties;
import com.jxdinfo.hussar.support.cache.support.properties.HussarSecurityProperties;
import com.jxdinfo.hussar.support.cache.support.redis.HussarSpringRedisCacheManger;
import com.jxdinfo.hussar.support.cache.support.redis.HussarSpringRedisCacheWriter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

@Import(value={HussarMultiLevelCacheProperties.class})
@AutoConfigureAfter(value={EhCacheConfiguration.class, HussarRedisAutoConfiguration.class})
@ConditionalOnExpression(value="'${hussar.cache.cache-type:ehcache}'.equals('redis') and ${hussar.cache.multi-level.enable:false}")
public class MultilevelCacheConfiguration {
    @Bean
    public EhCacheManagerFactoryBean firstLevelCacheManagerFactory() {
        ClassPathResource resource = new ClassPathResource("ehcache.xml");
        EhCacheManagerFactoryBean ehCacheManagerFactoryBean = new EhCacheManagerFactoryBean();
        ehCacheManagerFactoryBean.setConfigLocation((Resource)resource);
        return ehCacheManagerFactoryBean;
    }

    @Bean
    public SpringEhCacheCacheManager firstLevelCacheManager(HussarTenantProperties hussarTenantProperties, HussarSecurityProperties hussarSecurityProperties, HussarCacheProperties hussarCacheProperties, CacheNameCreator cacheNameCreator, EhCacheManagerFactoryBean firstLevelCacheManagerFactory) {
        SpringEhCacheCacheManager ehCacheCacheManager = new SpringEhCacheCacheManager();
        ehCacheCacheManager.setCacheManager(firstLevelCacheManagerFactory.getObject());
        List<String> noControlCacheName = hussarCacheProperties.getNoControlCacheName();
        if (HussarUtils.isEmpty(noControlCacheName)) {
            noControlCacheName = new ArrayList<String>();
            noControlCacheName.add(hussarSecurityProperties.getTokenName());
        } else if (!noControlCacheName.contains(hussarSecurityProperties.getTokenName())) {
            noControlCacheName.add(hussarSecurityProperties.getTokenName());
        }
        hussarCacheProperties.setNoControlCacheName(noControlCacheName);
        ehCacheCacheManager.setHussarCacheProperties(hussarCacheProperties);
        ehCacheCacheManager.setCacheNameCreator(cacheNameCreator);
        ehCacheCacheManager.setHussarTenantProperties(hussarTenantProperties);
        return ehCacheCacheManager;
    }

    @Bean
    public HussarSpringRedisCacheManger secondLevelCacheManager(HussarSpringRedisCacheWriter hussarSpringRedisCacheWriter, HussarTenantProperties hussarTenantProperties, HussarSecurityProperties hussarSecurityProperties, HussarCacheProperties hussarCacheProperties, CacheNameCreator cacheNameCreator) {
        return HussarRedisAutoConfiguration.getHussarSpringRedisCacheManger(hussarSpringRedisCacheWriter, hussarTenantProperties, hussarSecurityProperties, hussarCacheProperties, cacheNameCreator);
    }

    @Bean
    @Primary
    public CacheManager cacheManager(SpringEhCacheCacheManager firstLevelCacheManager, HussarSpringRedisCacheManger cacheManager, HussarCacheProperties hussarCacheProperties) {
        return new MultiLevelCacheManager(firstLevelCacheManager, cacheManager, hussarCacheProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.cache.multi-level", name={"second-level-change-notify-type"}, havingValue="default", matchIfMissing=true)
    public ISecondLevelCacheChangeNotify defaultSecondLevelCacheChangeNotify() {
        return new DefaultSecondLevelCacheChangeNotify();
    }

    @Bean
    @ConditionalOnBean(name={"defaultSecondLevelCacheChangeNotify"})
    public RedisMessageListenerContainer secondLevelCacheChangeListenerContainer(RedisConnectionFactory redisConnectionFactory, MultiLevelCacheManager multiLevelCacheManager, HussarTenantProperties hussarTenantProperties, ICacheTenantInfoHandler cacheTenantInfoHandler) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(redisConnectionFactory);
        container.addMessageListener((MessageListener)new SecondLevelCacheChangeListener(multiLevelCacheManager, hussarTenantProperties, cacheTenantInfoHandler), (Topic)new ChannelTopic("second_level_cache_change_notify"));
        return container;
    }

    @Bean
    @ConditionalOnMissingBean
    public ICacheTenantInfoHandler defaultCacheTenantInfoHandler() {
        return new DefaultCacheTenantInfoHandler();
    }
}

