/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.multilevel;

import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.support.HussarCache;
import com.jxdinfo.hussar.support.cache.support.multilevel.messagenotify.ICacheTenantInfoHandler;
import com.jxdinfo.hussar.support.cache.support.multilevel.messagenotify.ISecondLevelCacheChangeNotify;
import com.jxdinfo.hussar.support.cache.support.multilevel.messagenotify.SecondLevelCacheChangeMessage;
import com.jxdinfo.hussar.support.cache.support.properties.HussarMultiLevelCacheProperties;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;

public class MultiLevelCache
implements HussarCache {
    private Logger logger = LoggerFactory.getLogger(MultiLevelCache.class);
    private HussarCache firstLevelCache;
    private HussarCache secondLevelCache;
    private HussarMultiLevelCacheProperties multiLevelCacheProperties;
    private ISecondLevelCacheChangeNotify cacheChangeNotify;
    private ICacheTenantInfoHandler cacheTenantInfoHandler;
    private String cacheName;
    private String realCacheName;
    private Boolean useMultiLevelCache;
    private List<String> firstCacheHalfSave;

    public MultiLevelCache(HussarCache firstLevelCache, HussarCache secondLevelCache, HussarMultiLevelCacheProperties multiLevelCacheProperties, ISecondLevelCacheChangeNotify cacheChangeNotify, ICacheTenantInfoHandler cacheTenantInfoHandler, String originCacheName, String realCacheName) {
        this.firstLevelCache = firstLevelCache;
        this.secondLevelCache = secondLevelCache;
        this.multiLevelCacheProperties = multiLevelCacheProperties;
        this.cacheChangeNotify = cacheChangeNotify;
        this.cacheTenantInfoHandler = cacheTenantInfoHandler;
        this.cacheName = originCacheName;
        this.realCacheName = realCacheName;
        this.useMultiLevelCache = multiLevelCacheProperties.getEnableCacheName().contains(originCacheName);
        this.firstCacheHalfSave = multiLevelCacheProperties.getFirstCacheHalfSave();
    }

    @Override
    public void put(Object key, Object value, Duration timeout) {
        this.secondLevelCache.put(key, value, timeout);
        this.notifySecondLevelCacheChange(key, null);
        if (this.useMultiLevelCache.booleanValue()) {
            this.firstLevelCache.put(key, value, timeout);
        }
    }

    @Override
    public void put(Object key, Object value, long seconds) {
        this.secondLevelCache.put(key, value, seconds);
        this.notifySecondLevelCacheChange(key, null);
        if (this.useMultiLevelCache.booleanValue()) {
            this.firstLevelCache.put(key, value, seconds);
        }
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Cache.ValueWrapper result = this.secondLevelCache.putIfAbsent(key, value);
        this.notifySecondLevelCacheChange(key, null);
        if (this.useMultiLevelCache.booleanValue()) {
            this.firstLevelCache.putIfAbsent(key, value);
        }
        return result;
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, Object value, Duration timeout) {
        Cache.ValueWrapper result = this.secondLevelCache.putIfAbsent(key, value, timeout);
        this.notifySecondLevelCacheChange(key, null);
        if (this.useMultiLevelCache.booleanValue()) {
            this.firstLevelCache.putIfAbsent(key, value, timeout);
        }
        return result;
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, Object value, long seconds) {
        Cache.ValueWrapper result = this.secondLevelCache.putIfAbsent(key, value, seconds);
        this.notifySecondLevelCacheChange(key, null);
        if (this.useMultiLevelCache.booleanValue()) {
            this.firstLevelCache.putIfAbsent(key, value, seconds);
        }
        return result;
    }

    public boolean evictIfPresent(Object key) {
        this.secondLevelCache.evictIfPresent(key);
        this.notifySecondLevelCacheChange(key, null);
        if (this.useMultiLevelCache.booleanValue()) {
            this.firstLevelCache.evictIfPresent(key);
        }
        return false;
    }

    @Override
    public boolean containKey(Object key) {
        if (this.useMultiLevelCache.booleanValue() && this.firstLevelCache.containKey(key)) {
            return true;
        }
        return this.secondLevelCache.containKey(key);
    }

    @Override
    public List<String> getKeys(String key) {
        return this.secondLevelCache.getKeys(key);
    }

    @Override
    public List<String> scanKeys(String key) {
        return this.secondLevelCache.scanKeys(key);
    }

    @Override
    public void evictKeys(String key) {
        this.secondLevelCache.evictKeys(key);
        this.notifySecondLevelCacheChange(null, key);
        if (this.useMultiLevelCache.booleanValue()) {
            this.firstLevelCache.evictKeys(key);
        }
    }

    @Override
    public Map<String, Object> getKeysAndValues(String key) {
        Map<String, Object> result;
        if (this.useMultiLevelCache.booleanValue() && HussarUtils.isNotEmpty(result = this.firstLevelCache.getKeysAndValues(key))) {
            return result;
        }
        return this.secondLevelCache.getKeysAndValues(key);
    }

    @Override
    public Long getKeyExpireTime(Object key) {
        if (this.useMultiLevelCache.booleanValue() && this.firstLevelCache.containKey(key)) {
            return this.firstLevelCache.getKeyExpireTime(key);
        }
        return this.secondLevelCache.getKeyExpireTime(key);
    }

    @Override
    public void putSet(Object key, Set<Object> value, long seconds) {
        this.secondLevelCache.putSet(key, value, seconds);
        this.notifySecondLevelCacheChange(key, null);
        if (this.useMultiLevelCache.booleanValue() && this.firstCacheHalfSave.stream().noneMatch(action -> key.toString().startsWith((String)action))) {
            this.firstLevelCache.putSet(key, value, seconds);
        }
    }

    @Override
    public Map<Object, Boolean> containsValues(Object key, List<Object> values) {
        if (this.useMultiLevelCache.booleanValue()) {
            Map<Object, Boolean> firstCacheResult = this.firstLevelCache.containsValues(key, values);
            List<Object> values2 = values;
            if (CollectionUtil.isNotEmpty(firstCacheResult) && CollectionUtil.isEmpty(values2 = values.stream().filter(action -> firstCacheResult.get(action) == null).collect(Collectors.toList()))) {
                return firstCacheResult;
            }
            Map<Object, Boolean> secondCacheResult = this.secondLevelCache.containsValues(key, values2);
            Long keyExpireTime = this.secondLevelCache.getKeyExpireTime(key);
            if (keyExpireTime > 0L) {
                this.firstLevelCache.putSet(key, secondCacheResult, (long)this.secondLevelCache.getKeyExpireTime(key));
            }
            firstCacheResult.putAll(secondCacheResult);
            return firstCacheResult;
        }
        return this.secondLevelCache.containsValues(key, values);
    }

    @Override
    public Set<Object> getSet(Object key) {
        Set<Object> value = this.secondLevelCache.getSet(key);
        if (HussarUtils.isEmpty(value)) {
            this.loadValueFromSecondToFirstCache(key, value);
        }
        return value;
    }

    @Override
    public void updateKeyTimeout(Object key, long timeout) {
        this.secondLevelCache.updateKeyTimeout(key, timeout);
        this.notifySecondLevelCacheChange(key, null);
        if (this.useMultiLevelCache.booleanValue()) {
            this.firstLevelCache.updateKeyTimeout(key, timeout);
        }
    }

    @Override
    public void putHash(Object key, Map<Object, Object> value, long timeout) {
        this.secondLevelCache.putHash(key, value, timeout);
        this.notifySecondLevelCacheChange(key, null);
        if (this.useMultiLevelCache.booleanValue()) {
            this.firstLevelCache.putHash(key, value, timeout);
        }
    }

    @Override
    public Object getFieldValue(Object key, Object field) {
        Object val;
        if (this.useMultiLevelCache.booleanValue() && HussarUtils.isNotEmpty((Object)(val = this.firstLevelCache.getFieldValue(key, field)))) {
            return val;
        }
        return this.secondLevelCache.getFieldValue(key, field);
    }

    @Override
    public void addField(Object key, Object field, Object value) {
        this.secondLevelCache.addField(key, field, value);
        this.notifySecondLevelCacheChange(key, null);
        if (this.useMultiLevelCache.booleanValue()) {
            this.firstLevelCache.addField(key, field, value);
        }
    }

    @Override
    public Map<Object, Object> getHash(Object key) {
        Map<Object, Object> result;
        if (this.useMultiLevelCache.booleanValue() && HussarUtils.isNotEmpty(result = this.firstLevelCache.getHash(key))) {
            return result;
        }
        return this.secondLevelCache.getHash(key);
    }

    @Override
    public void removeField(Object key, Object field) {
        this.secondLevelCache.removeField(key, field);
        this.notifySecondLevelCacheChange(key, null);
        if (this.useMultiLevelCache.booleanValue()) {
            this.firstLevelCache.removeField(key, field);
        }
    }

    @Override
    public List<Object> getHashValsWithKeyPattern(String keyPrefix) {
        List<Object> cacheValues;
        if (this.useMultiLevelCache.booleanValue() && HussarUtils.isNotEmpty(cacheValues = this.firstLevelCache.getHashValsWithKeyPattern(keyPrefix))) {
            return cacheValues;
        }
        return this.secondLevelCache.getHashValsWithKeyPattern(keyPrefix);
    }

    public String getName() {
        return this.realCacheName;
    }

    public Object getNativeCache() {
        return this;
    }

    public Cache.ValueWrapper get(Object o) {
        Cache.ValueWrapper wrapper;
        if (this.useMultiLevelCache.booleanValue() && (wrapper = this.firstLevelCache.get(o)) != null) {
            return wrapper;
        }
        wrapper = this.secondLevelCache.get(o);
        if (wrapper != null) {
            this.loadValueFromSecondToFirstCache(o, wrapper.get());
        }
        return wrapper;
    }

    public <T> T get(Object o, Class<T> aClass) {
        Object value;
        if (this.useMultiLevelCache.booleanValue() && HussarUtils.isNotEmpty((Object)(value = this.firstLevelCache.get(o, aClass)))) {
            return (T)value;
        }
        value = this.secondLevelCache.get(o, aClass);
        this.loadValueFromSecondToFirstCache(o, value);
        return (T)value;
    }

    public <T> T get(Object o, Callable<T> callable) {
        Cache.ValueWrapper wrapper;
        if (this.useMultiLevelCache.booleanValue() && (wrapper = this.firstLevelCache.get(o)) != null) {
            return (T)wrapper.get();
        }
        wrapper = this.secondLevelCache.get(o);
        if (wrapper != null) {
            this.loadValueFromSecondToFirstCache(o, wrapper.get());
            return (T)wrapper.get();
        }
        return MultiLevelCache.valueFromLoader(o, callable);
    }

    public void put(Object o, Object o1) {
        this.secondLevelCache.put(o, o1);
        this.notifySecondLevelCacheChange(o, null);
        if (this.useMultiLevelCache.booleanValue()) {
            this.firstLevelCache.put(o, o1);
        }
    }

    public void evict(Object o) {
        this.secondLevelCache.evict(o);
        this.notifySecondLevelCacheChange(o, null);
        if (this.useMultiLevelCache.booleanValue()) {
            this.firstLevelCache.evict(o);
        }
    }

    public void clear() {
        this.secondLevelCache.clear();
        this.notifySecondLevelCacheChange(null, "*");
        if (this.useMultiLevelCache.booleanValue()) {
            this.firstLevelCache.clear();
        }
    }

    private void notifySecondLevelCacheChange(Object key, Object keyPattern) {
        if (!this.useMultiLevelCache.booleanValue()) {
            return;
        }
        SecondLevelCacheChangeMessage message = new SecondLevelCacheChangeMessage();
        message.setCacheName(this.cacheName);
        Object tenantInfo = this.cacheTenantInfoHandler.getTenantInfoFromContext();
        message.setTenantInfo(JsonUtil.toJson((Object)tenantInfo));
        message.setTenantInfoClassName(tenantInfo.getClass().getName());
        message.setKey(key);
        message.setKeyPattern(keyPattern);
        try {
            this.cacheChangeNotify.notifyChange(message);
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001\u4e8c\u7ea7\u7f13\u5b58\u53d8\u66f4\u901a\u77e5\u5f02\u5e38, cacheName = {}, tenantInfo = {}, key = {}, keyPattern = {}", new Object[]{this.cacheName, JsonUtil.toJson((Object)message.getTenantInfo()), key, keyPattern, e});
        }
    }

    private void loadValueFromSecondToFirstCache(Object key, Object value) {
        if (this.useMultiLevelCache.booleanValue() && HussarUtils.isNotEmpty((Object)value)) {
            try {
                Long keyExpireTime = this.secondLevelCache.getKeyExpireTime(key);
                if (HussarUtils.isEmpty((Object)keyExpireTime)) {
                    this.firstLevelCache.put(key, value, Duration.ZERO);
                } else {
                    this.firstLevelCache.put(key, value, keyExpireTime);
                }
            }
            catch (Exception e) {
                this.logger.error("\u5c06\u4e8c\u7ea7\u7f13\u5b58\u5185\u6570\u636e\u52a0\u8f7d\u5165\u4e00\u7ea7\u7f13\u5b58\u5f02\u5e38, cacheName = {}, key = {}", new Object[]{this.cacheName, key, e});
            }
        }
    }

    private static <T> T valueFromLoader(Object key, Callable<T> valueLoader) {
        try {
            return valueLoader.call();
        }
        catch (Exception e) {
            throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
        }
    }
}

