/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.redis;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.support.redis.HussarSpringRedisCacheWriter;
import com.jxdinfo.hussar.support.cache.support.redis.SpringAbstractValueAdaptingCache;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import org.springframework.cache.Cache;
import org.springframework.cache.support.NullValue;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class HussarSpringRedisCache
extends SpringAbstractValueAdaptingCache {
    private static final byte[] BINARY_NULL_VALUE = RedisSerializer.java().serialize(NullValue.INSTANCE);
    private final String name;
    private final HussarSpringRedisCacheWriter cacheWriter;
    private final RedisCacheConfiguration cacheConfig;
    private final ConversionService conversionService;

    protected HussarSpringRedisCache(String name, HussarSpringRedisCacheWriter cacheWriter, RedisCacheConfiguration cacheConfig) {
        super(cacheConfig.getAllowCacheNullValues());
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
        Assert.notNull((Object)cacheConfig, (String)"CacheConfig must not be null!");
        this.name = name;
        this.cacheWriter = cacheWriter;
        this.cacheConfig = cacheConfig;
        this.conversionService = cacheConfig.getConversionService();
    }

    @Override
    protected Object lookup(Object key) {
        byte[] value = this.cacheWriter.get(this.name, this.createAndConvertCacheKey(key));
        if (value == null) {
            return null;
        }
        return this.deserializeCacheValue(value);
    }

    public String getName() {
        return this.name;
    }

    public RedisCacheWriter getNativeCache() {
        return this.cacheWriter;
    }

    public synchronized <T> T get(Object key, Callable<T> valueLoader) {
        Cache.ValueWrapper result = this.get(key);
        if (result != null) {
            return (T)result.get();
        }
        T value = HussarSpringRedisCache.valueFromLoader(key, valueLoader);
        this.put(key, value);
        return value;
    }

    public void put(Object key, @Nullable Object value) {
        Object cacheValue = this.preProcessCacheValue(value);
        if (!this.isAllowNullValues() && cacheValue == null) {
            throw new IllegalArgumentException(String.format("Cache '%s' does not allow 'null' values. Avoid storing null via '@Cacheable(unless=\"#result == null\")' or configure RedisCache to allow 'null' via RedisCacheConfiguration.", this.name));
        }
        this.cacheWriter.put(this.name, this.createAndConvertCacheKey(key), this.serializeCacheValue(cacheValue), this.cacheConfig.getTtl());
    }

    @Override
    public void put(Object key, Object value, Duration timeout) {
        Object cacheValue = this.preProcessCacheValue(value);
        if (!this.isAllowNullValues() && cacheValue == null) {
            throw new IllegalArgumentException(String.format("Cache '%s' does not allow 'null' values. Avoid storing null via '@Cacheable(unless=\"#result == null\")' or configure RedisCache to allow 'null' via RedisCacheConfiguration.", this.name));
        }
        this.cacheWriter.put(this.name, this.createAndConvertCacheKey(key), this.serializeCacheValue(value), timeout);
    }

    @Override
    public void put(Object key, Object value, long seconds) {
        Duration timeoutDuration = null;
        timeoutDuration = seconds > 0L ? Duration.ofSeconds(seconds) : Duration.ZERO;
        this.put(key, value, timeoutDuration);
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value) {
        Object cacheValue = this.preProcessCacheValue(value);
        if (!this.isAllowNullValues() && cacheValue == null) {
            return this.get(key);
        }
        byte[] result = this.cacheWriter.putIfAbsent(this.name, this.createAndConvertCacheKey(key), this.serializeCacheValue(cacheValue), this.cacheConfig.getTtl());
        if (result == null) {
            return null;
        }
        return new SimpleValueWrapper(this.fromStoreValue(this.deserializeCacheValue(result)));
    }

    @Override
    public boolean containKey(Object key) {
        return this.cacheWriter.execute(this.name, conection -> conection.exists((byte[])this.conversionService.convert((Object)this.createCacheKey(key), byte[].class)));
    }

    @Override
    public List<String> getKeys(String key) {
        List<String> keys = this.scanKeys(key);
        ArrayList<String> returnKeys = new ArrayList<String>();
        keys.forEach(k -> returnKeys.add(this.removeKeyPrefix((String)k)));
        return returnKeys;
    }

    @Override
    public List<String> scanKeys(String key) {
        if (this.cacheWriter.isClusterAware()) {
            return this.cacheWriter.execute(this.name, connection -> {
                byte[] pattern = (byte[])this.conversionService.convert((Object)this.createCacheKey(key), byte[].class);
                List<Object> keys = new ArrayList();
                ArrayList finalKeys = new ArrayList();
                LettuceClusterConnection clusterConn = (LettuceClusterConnection)connection;
                List nodes = clusterConn.clusterGetNodes();
                for (RedisClusterNode node : nodes) {
                    if (!node.isMaster() || !node.isConnected() || node.isMarkedAsFail()) continue;
                    Cursor cursor = clusterConn.scan(node, ScanOptions.scanOptions().match(this.redisDeserializeCacheKey(pattern)).count(1000L).build());
                    cursor.forEachRemaining(next -> finalKeys.add(this.redisDeserializeCacheKey((byte[])next)));
                }
                keys = Optional.ofNullable(finalKeys).orElse(Collections.emptyList());
                return keys;
            });
        }
        return this.cacheWriter.execute(this.name, connection -> {
            byte[] pattern = (byte[])this.conversionService.convert((Object)this.createCacheKey(key), byte[].class);
            List<Object> keys = new ArrayList();
            ArrayList finalKeys = new ArrayList();
            connection.scan(ScanOptions.scanOptions().match(this.redisDeserializeCacheKey(pattern)).count(1000L).build()).forEachRemaining(next -> finalKeys.add(this.redisDeserializeCacheKey((byte[])next)));
            keys = Optional.ofNullable(finalKeys).orElse(Collections.emptyList());
            return keys;
        });
    }

    @Override
    public void evictKeys(String key) {
        byte[] pattern = (byte[])this.conversionService.convert((Object)this.createCacheKey(key), byte[].class);
        if (this.cacheWriter.isClusterAware()) {
            this.cacheWriter.execute(this.name, connection -> {
                LettuceClusterConnection clusterConn = (LettuceClusterConnection)connection;
                boolean wasLocked = false;
                try {
                    if (this.cacheWriter.isLockingCacheWriter()) {
                        this.cacheWriter.doLock(this.name, (RedisConnection)clusterConn);
                        wasLocked = true;
                    }
                    ArrayList finalKeys = new ArrayList();
                    List nodes = clusterConn.clusterGetNodes();
                    for (RedisClusterNode node : nodes) {
                        if (!node.isMaster() || !node.isConnected() || node.isMarkedAsFail()) continue;
                        Cursor cursor = clusterConn.scan(node, ScanOptions.scanOptions().match(this.redisDeserializeCacheKey(pattern)).count(1000L).build());
                        cursor.forEachRemaining(next -> finalKeys.add(next));
                        cursor.close();
                    }
                    byte[][] keys = (byte[][])Optional.ofNullable(LettuceConverters.toBytesSet(finalKeys)).orElse(Collections.emptySet()).toArray((T[])new byte[0][]);
                    if (keys.length > 0) {
                        clusterConn.keyCommands().del(keys);
                    }
                }
                finally {
                    if (wasLocked && this.cacheWriter.isLockingCacheWriter()) {
                        this.cacheWriter.doUnlock(this.name, (RedisConnection)connection);
                    }
                }
                return "OK";
            });
        } else {
            this.cacheWriter.execute(this.name, connection -> {
                boolean wasLocked = false;
                try {
                    if (this.cacheWriter.isLockingCacheWriter()) {
                        this.cacheWriter.doLock(this.name, (RedisConnection)connection);
                        wasLocked = true;
                    }
                    ArrayList finalKeys = new ArrayList();
                    connection.scan(ScanOptions.scanOptions().match(this.redisDeserializeCacheKey(pattern)).count(1000L).build()).forEachRemaining(next -> finalKeys.add(next));
                    byte[][] keys = (byte[][])Optional.ofNullable(LettuceConverters.toBytesSet(finalKeys)).orElse(Collections.emptySet()).toArray((T[])new byte[0][]);
                    if (keys.length > 0) {
                        connection.del(keys);
                    }
                }
                finally {
                    if (wasLocked && this.cacheWriter.isLockingCacheWriter()) {
                        this.cacheWriter.doUnlock(this.name, (RedisConnection)connection);
                    }
                }
                return "OK";
            });
        }
    }

    @Override
    public Map<String, Object> getKeysAndValues(String key) {
        if (this.cacheWriter.isClusterAware()) {
            return this.cacheWriter.execute(this.name, connection -> {
                byte[] pattern = (byte[])this.conversionService.convert((Object)this.createAndConvertCacheKey(key), byte[].class);
                HashMap mp = new HashMap();
                LettuceClusterConnection clusterConn = (LettuceClusterConnection)connection;
                List nodes = clusterConn.clusterGetNodes();
                for (RedisClusterNode node : nodes) {
                    if (!node.isMaster() || !node.isConnected() || node.isMarkedAsFail()) continue;
                    Cursor cursor = clusterConn.scan(node, ScanOptions.scanOptions().match(this.redisDeserializeCacheKey(pattern)).count(1000L).build());
                    cursor.forEachRemaining(next -> mp.put(this.redisDeserializeCacheKey((byte[])next), this.deserializeCacheValue(clusterConn.stringCommands().get(next))));
                }
                return mp;
            });
        }
        return this.cacheWriter.execute(this.name, connection -> {
            byte[] pattern = (byte[])this.conversionService.convert((Object)this.createAndConvertCacheKey(key), byte[].class);
            HashMap mp = new HashMap();
            connection.scan(ScanOptions.scanOptions().match(this.redisDeserializeCacheKey(pattern)).count(1000L).build()).forEachRemaining(next -> mp.put(this.redisDeserializeCacheKey((byte[])next), this.deserializeCacheValue(connection.get(next))));
            return mp;
        });
    }

    @Override
    public Long getKeyExpireTime(Object key) {
        Long timeout = this.cacheWriter.execute(this.name, conection -> conection.ttl((byte[])this.conversionService.convert((Object)this.createCacheKey(key), byte[].class)));
        return timeout;
    }

    public void evict(Object key) {
        this.cacheWriter.remove(this.name, this.createAndConvertCacheKey(key));
    }

    @Override
    public void putSet(Object key, Set<Object> values, long seconds) {
        if (null == values || values.isEmpty()) {
            return;
        }
        int size = values.size();
        byte[][] value = new byte[size][];
        int i = 0;
        for (Object val : values) {
            value[i] = this.serializeCacheValue(val);
            ++i;
        }
        this.cacheWriter.putSet(this.name, this.createAndConvertCacheKey(key), value, Duration.ofSeconds(seconds));
    }

    @Override
    public Boolean containsValue(Object key, Object value) {
        return this.cacheWriter.containsValue(this.name, this.createAndConvertCacheKey(key), this.serializeCacheValue(value));
    }

    @Override
    public Map<Object, Boolean> containsValues(Object key, List<Object> values) {
        if (null == values || values.isEmpty()) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        int size = values.size();
        byte[][] value = new byte[size][];
        for (int i = 0; i < size; ++i) {
            value[i] = this.serializeCacheValue(values.get(i));
        }
        List<Boolean> cacheResult = this.cacheWriter.containsValues(this.name, this.createAndConvertCacheKey(key), value);
        HashMap result = Maps.newHashMapWithExpectedSize((int)values.size());
        for (int i = 0; i < values.size(); ++i) {
            result.put(values.get(i), cacheResult.get(i));
        }
        return result;
    }

    @Override
    public Set<Object> getSet(Object key) {
        Set<byte[]> result = this.cacheWriter.getSet(this.name, this.createAndConvertCacheKey(key));
        if (null == result || result.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet values = Sets.newHashSetWithExpectedSize((int)result.size());
        for (byte[] res : result) {
            values.add(this.deserializeCacheValue(res));
        }
        return values;
    }

    @Override
    public void putHash(Object key, Map<Object, Object> value, long timeout) {
        HashMap byteMap = Maps.newHashMapWithExpectedSize((int)value.size());
        for (Map.Entry<Object, Object> entry : value.entrySet()) {
            byteMap.put(this.serializeCacheValue(entry.getKey()), this.serializeCacheValue(entry.getValue()));
        }
        this.cacheWriter.putHash(this.name, this.createAndConvertCacheKey(key), byteMap, timeout == -1L ? Duration.ZERO : Duration.ofSeconds(timeout));
    }

    @Override
    public Object getFieldValue(Object key, Object field) {
        byte[] value = this.cacheWriter.getFieldValue(this.name, this.createAndConvertCacheKey(key), this.serializeCacheValue(field));
        if (HussarUtils.isEmpty((Object)value)) {
            return null;
        }
        return this.deserializeCacheValue(value);
    }

    @Override
    public void addField(Object key, Object field, Object value) {
        this.cacheWriter.addField(this.name, this.createAndConvertCacheKey(key), this.serializeCacheValue(field), this.serializeCacheValue(value));
    }

    @Override
    public Map<Object, Object> getHash(Object key) {
        Map<byte[], byte[]> cacheMap = this.cacheWriter.getHash(this.name, this.createAndConvertCacheKey(key));
        if (HussarUtils.isEmpty(cacheMap)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)cacheMap.size());
        for (Map.Entry<byte[], byte[]> entry : cacheMap.entrySet()) {
            result.put(this.deserializeCacheValue(entry.getKey()), this.deserializeCacheValue(entry.getValue()));
        }
        return result;
    }

    @Override
    public void updateKeyTimeout(Object key, long seconds) {
        this.cacheWriter.updateKeyTimeout(this.name, this.createAndConvertCacheKey(key), seconds);
    }

    @Override
    public void removeField(Object key, Object field) {
        this.cacheWriter.removeField(this.name, this.createAndConvertCacheKey(key), this.serializeCacheValue(field));
    }

    @Override
    public List<Object> getHashValsWithKeyPattern(String keyPrefix) {
        List<byte[]> cacheValues = this.cacheWriter.getHashValsWithKeys(this.name, keyPrefix = keyPrefix + ":*");
        if (HussarUtils.isEmpty(cacheValues)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)cacheValues.size());
        for (byte[] cacheValue : cacheValues) {
            if (null == cacheValue) continue;
            result.add(this.deserializeCacheValue(cacheValue));
        }
        return result;
    }

    public void clear() {
        byte[] pattern = (byte[])this.conversionService.convert((Object)this.createCacheKey("*"), byte[].class);
        this.cacheWriter.clean(this.name, pattern);
    }

    public RedisCacheConfiguration getCacheConfiguration() {
        return this.cacheConfig;
    }

    @Nullable
    protected Object preProcessCacheValue(@Nullable Object value) {
        if (value != null) {
            return value;
        }
        return this.isAllowNullValues() ? NullValue.INSTANCE : null;
    }

    protected byte[] serializeCacheKey(String cacheKey) {
        return ByteUtils.getBytes((ByteBuffer)this.cacheConfig.getKeySerializationPair().write((Object)cacheKey));
    }

    protected byte[] serializeCacheValue(Object value) {
        if (this.isAllowNullValues() && value instanceof NullValue) {
            return BINARY_NULL_VALUE;
        }
        return ByteUtils.getBytes((ByteBuffer)this.cacheConfig.getValueSerializationPair().write(value));
    }

    @Nullable
    protected Object deserializeCacheValue(byte[] value) {
        if (this.isAllowNullValues() && ObjectUtils.nullSafeEquals((Object)value, (Object)BINARY_NULL_VALUE)) {
            return NullValue.INSTANCE;
        }
        return this.cacheConfig.getValueSerializationPair().read(ByteBuffer.wrap(value));
    }

    protected String createCacheKey(Object key) {
        String cacheKey = this.convertKey(key);
        if (this.cacheConfig.usePrefix()) {
            String keyPrefixFor = this.cacheConfig.getKeyPrefixFor(this.name);
            boolean flag = StringUtil.startWith((CharSequence)cacheKey, (CharSequence)"*");
            if (flag) {
                cacheKey = StringUtil.removePrefix((CharSequence)cacheKey, (CharSequence)"*");
            }
            cacheKey = StringUtil.removePrefix((CharSequence)cacheKey, (CharSequence)keyPrefixFor);
            if (flag) {
                cacheKey = StringUtil.addPrefixIfNot((CharSequence)cacheKey, (CharSequence)"*");
            }
        }
        if (!this.cacheConfig.usePrefix()) {
            return cacheKey;
        }
        return this.prefixCacheKey(cacheKey);
    }

    protected String removeKeyPrefix(String key) {
        if (!this.cacheConfig.usePrefix()) {
            return key;
        }
        String keyPrefix = this.cacheConfig.getKeyPrefixFor(this.name);
        return StringUtil.removePrefix((CharSequence)key, (CharSequence)keyPrefix);
    }

    protected String convertKey(Object key) {
        if (key instanceof String) {
            return (String)key;
        }
        TypeDescriptor source = TypeDescriptor.forObject((Object)key);
        if (this.conversionService.canConvert(source, TypeDescriptor.valueOf(String.class))) {
            try {
                return (String)this.conversionService.convert(key, String.class);
            }
            catch (ConversionFailedException e) {
                if (this.isCollectionLikeOrMap(source)) {
                    return this.convertCollectionLikeOrMapKey(key, source);
                }
                throw e;
            }
        }
        Method toString = ReflectionUtils.findMethod(key.getClass(), (String)"toString");
        if (toString != null && !Object.class.equals(toString.getDeclaringClass())) {
            return key.toString();
        }
        throw new IllegalStateException(String.format("Cannot convert cache key %s to String. Please register a suitable Converter via 'RedisCacheConfiguration.configureKeyConverters(...)' or override '%s.toString()'.", source, key.getClass().getSimpleName()));
    }

    private String convertCollectionLikeOrMapKey(Object key, TypeDescriptor source) {
        if (source.isMap()) {
            StringBuilder target = new StringBuilder("{");
            for (Map.Entry entry : ((Map)key).entrySet()) {
                target.append(this.convertKey(entry.getKey())).append("=").append(this.convertKey(entry.getValue()));
            }
            target.append("}");
            return target.toString();
        }
        if (source.isCollection() || source.isArray()) {
            StringJoiner sj = new StringJoiner(",");
            List<Object> collection = source.isCollection() ? (List<Object>)key : Arrays.asList(ObjectUtils.toObjectArray((Object)key));
            for (Object e : collection) {
                sj.add(this.convertKey(e));
            }
            return "[" + sj.toString() + "]";
        }
        throw new IllegalArgumentException(String.format("Cannot convert cache key %s to String.", key));
    }

    private boolean isCollectionLikeOrMap(TypeDescriptor source) {
        return source.isArray() || source.isCollection() || source.isMap();
    }

    private byte[] createAndConvertCacheKey(Object key) {
        return this.serializeCacheKey(this.createCacheKey(key));
    }

    private String prefixCacheKey(String key) {
        return this.cacheConfig.getKeyPrefixFor(this.name) + key;
    }

    private static <T> T valueFromLoader(Object key, Callable<T> valueLoader) {
        try {
            return valueLoader.call();
        }
        catch (Exception e) {
            throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
        }
    }

    private byte[] redisSerializeCacheValue(Object value) {
        return this.serializeCacheValue(value);
    }

    private String redisDeserializeCacheKey(byte[] keyByte) {
        return (String)this.cacheConfig.getKeySerializationPair().read(ByteBuffer.wrap(keyByte));
    }
}

