/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.multilevel.messagenotify;

import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.support.HussarCache;
import com.jxdinfo.hussar.support.cache.support.multilevel.MultiLevelCacheManager;
import com.jxdinfo.hussar.support.cache.support.multilevel.messagenotify.ICacheTenantInfoHandler;
import com.jxdinfo.hussar.support.cache.support.multilevel.messagenotify.SecondLevelCacheChangeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

public class SecondLevelCacheChangeListener
implements MessageListener {
    protected static final Logger logger = LoggerFactory.getLogger(SecondLevelCacheChangeListener.class);
    private MultiLevelCacheManager multiLevelCacheManager;
    private HussarTenantProperties tenantProperties;
    private ICacheTenantInfoHandler cacheTenantInfoHandler;

    public SecondLevelCacheChangeListener(CacheManager multiLevelCacheManager, HussarTenantProperties tenantProperties, ICacheTenantInfoHandler cacheTenantInfoHandler) {
        this.multiLevelCacheManager = (MultiLevelCacheManager)multiLevelCacheManager;
        this.tenantProperties = tenantProperties;
        this.cacheTenantInfoHandler = cacheTenantInfoHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message, byte[] bytes) {
        SecondLevelCacheChangeMessage messageBody = null;
        try {
            Object tenantInfo;
            if (!HussarUtils.isNotEmpty((Object)message) || !HussarUtils.isNotEmpty((Object)message.getBody())) {
                logger.error("\u6536\u5230\u4e8c\u7ea7\u7f13\u5b58\u53d8\u66f4\u901a\u77e5\uff0c\u6d88\u606f\u4f53\u4e3a\u7a7a");
                return;
            }
            messageBody = (SecondLevelCacheChangeMessage)JsonUtil.parse((byte[])message.getBody(), SecondLevelCacheChangeMessage.class);
            if (this.tenantProperties.isEnabled() && HussarUtils.isNotEmpty((Object)(tenantInfo = JsonUtil.parse((String)messageBody.getTenantInfo(), Class.forName(messageBody.getTenantInfoClassName()))))) {
                this.cacheTenantInfoHandler.setTenantInfoToContext(tenantInfo);
            }
            HussarCache firstLevelCache = (HussarCache)this.multiLevelCacheManager.getFirstLevelCacheManager().getCache(messageBody.getCacheName());
            if (HussarUtils.isNotEmpty((Object)messageBody.getKey())) {
                firstLevelCache.evict(messageBody.getKey());
            }
            if (HussarUtils.isNotEmpty((Object)messageBody.getKeyPattern())) {
                firstLevelCache.evictKeys(messageBody.getKeyPattern().toString());
            }
        }
        catch (Exception e) {
            logger.error("\u6536\u5230\u4e8c\u7ea7\u7f13\u5b58\u53d8\u66f4\u901a\u77e5, \u5220\u9664\u672c\u5730\u4e00\u7ea7\u7f13\u5b58\u5931\u8d25, message = {}", (Object)JsonUtil.toJson(messageBody), (Object)e);
        }
        finally {
            if (this.tenantProperties.isEnabled()) {
                this.cacheTenantInfoHandler.removeTenantInfo();
            }
        }
    }
}

