/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.multilevel;

import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.support.CacheNameCreator;
import com.jxdinfo.hussar.support.cache.support.HussarCache;
import com.jxdinfo.hussar.support.cache.support.multilevel.MultiLevelCache;
import com.jxdinfo.hussar.support.cache.support.multilevel.messagenotify.ICacheTenantInfoHandler;
import com.jxdinfo.hussar.support.cache.support.multilevel.messagenotify.ISecondLevelCacheChangeNotify;
import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import com.jxdinfo.hussar.support.cache.support.properties.HussarMultiLevelCacheProperties;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Resource;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class MultiLevelCacheManager
implements CacheManager {
    private CacheManager firstLevelCacheManager;
    private CacheManager secondLevelCacheManager;
    private HussarCacheProperties hussarCacheProperties;
    @Resource
    private HussarMultiLevelCacheProperties multiLevelCacheProperties;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Resource
    private ICacheTenantInfoHandler cacheTenantInfoHandler;
    @Resource
    private CacheNameCreator cacheNameCreator;
    @Resource
    private ISecondLevelCacheChangeNotify cacheChangeNotify;
    private final ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>(16);

    public MultiLevelCacheManager(CacheManager firstLevelCacheManager, CacheManager secondLevelCacheManager, HussarCacheProperties hussarCacheProperties) {
        this.firstLevelCacheManager = firstLevelCacheManager;
        this.secondLevelCacheManager = secondLevelCacheManager;
        this.hussarCacheProperties = hussarCacheProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache(String cacheName) {
        Cache cache;
        String realUsedCacheName = cacheName;
        boolean isFixed = StringUtil.startWith((CharSequence)cacheName, (CharSequence)"fixed_cache_name_prefix::");
        if (this.isDoHandlerCacheName(cacheName) && !isFixed) {
            realUsedCacheName = this.cacheNameCreator.creatCacheName(cacheName, this.hussarCacheProperties);
        }
        if (isFixed) {
            realUsedCacheName = StringUtil.removePrefix((CharSequence)realUsedCacheName, (CharSequence)"fixed_cache_name_prefix::");
        }
        if ((cache = (Cache)this.cacheMap.get(realUsedCacheName)) != null) {
            return cache;
        }
        MultiLevelCache missingCache = this.createCache(cacheName, realUsedCacheName);
        if (missingCache != null) {
            ConcurrentMap<String, Cache> concurrentMap = this.cacheMap;
            synchronized (concurrentMap) {
                cache = (Cache)this.cacheMap.get(realUsedCacheName);
                if (cache == null) {
                    cache = missingCache;
                    this.cacheMap.put(realUsedCacheName, cache);
                }
            }
        }
        return cache;
    }

    public Collection<String> getCacheNames() {
        return this.cacheMap.keySet();
    }

    public CacheManager getFirstLevelCacheManager() {
        return this.firstLevelCacheManager;
    }

    public CacheManager getSecondLevelCacheManager() {
        return this.secondLevelCacheManager;
    }

    private boolean isDoHandlerCacheName(String cacheName) {
        if (!this.hussarTenantProperties.isEnabled()) {
            return false;
        }
        boolean flag = false;
        List<String> noControlCacheName = this.hussarCacheProperties.getNoControlCacheName();
        if (HussarUtils.isEmpty(noControlCacheName)) {
            flag = true;
        } else if (!noControlCacheName.contains(cacheName)) {
            flag = true;
        }
        return flag;
    }

    private MultiLevelCache createCache(String cacheName, String realUsedCacheName) {
        HussarCache firstCache = (HussarCache)this.firstLevelCacheManager.getCache(cacheName);
        HussarCache secondCache = (HussarCache)this.secondLevelCacheManager.getCache(cacheName);
        return new MultiLevelCache(firstCache, secondCache, this.multiLevelCacheProperties, this.cacheChangeNotify, this.cacheTenantInfoHandler, cacheName, realUsedCacheName);
    }
}

