/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support;

import com.jxdinfo.hussar.platform.core.support.service.CacheCreatorService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.support.CacheNameCreator;
import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultCacheNameCreator
extends CacheNameCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCacheNameCreator.class);
    private final String CACHE_NAME_EXPR = "${cachePrefix}:${cacheName}";
    @Autowired(required=false)
    private CacheCreatorService cacheCreatorService;

    @Override
    public String creatCacheName(String cacheName, HussarCacheProperties hussarCacheProperties) {
        if (HussarUtils.isEmpty((Object)this.cacheCreatorService)) {
            LOGGER.debug("\u672a\u4f20\u9012cacheCreatorService \uff0c\u76f4\u63a5\u8fd4\u56de\u5bf9\u5e94\u7684cachename");
            return cacheName;
        }
        String cachePrefix = this.cacheCreatorService.creatorCachePrefix();
        if (HussarUtils.isEmpty((Object)cachePrefix)) {
            LOGGER.debug("\u672a\u8fd4\u56de\u7f13\u5b58\u524d\u7f00,\u76f4\u63a5\u8fd4\u56de\u5bf9\u5e94\u7684cachename");
            return cacheName;
        }
        HashMap<String, String> expressMap = new HashMap<String, String>();
        expressMap.put(this.CACHE_NAME_PREFIX, cachePrefix);
        expressMap.put(this.CACHE_NAME_KEY, cacheName);
        return StringUtil.format((String)"${cachePrefix}:${cacheName}", expressMap);
    }
}

