/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.exception.HussarRedisUrlSyntaxException;
import com.jxdinfo.hussar.support.cache.support.CacheNameCreator;
import com.jxdinfo.hussar.support.cache.support.ConnectionInfo;
import com.jxdinfo.hussar.support.cache.support.DefaultCacheNameCreator;
import com.jxdinfo.hussar.support.cache.support.PoolBuilderFactory;
import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import com.jxdinfo.hussar.support.cache.support.properties.HussarSecurityProperties;
import com.jxdinfo.hussar.support.cache.support.redis.ClusterTypeEnum;
import com.jxdinfo.hussar.support.cache.support.redis.HussarSpringRedisCacheManger;
import com.jxdinfo.hussar.support.cache.support.redis.HussarSpringRedisCacheWriter;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.SocketOptions;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={HussarCacheProperties.class})
@ConditionalOnProperty(prefix="hussar.cache", name={"cache-type"}, havingValue="redis")
public class HussarRedisAutoConfiguration
extends CachingConfigurerSupport {
    private final Logger logger = LoggerFactory.getLogger(HussarRedisAutoConfiguration.class);
    private static final boolean COMMONS_POOL2_AVAILABLE = ClassUtils.isPresent((String)"org.apache.commons.pool2.ObjectPool", (ClassLoader)HussarRedisAutoConfiguration.class.getClassLoader());
    private HussarCacheProperties hussarCacheProperties;

    public HussarRedisAutoConfiguration(HussarCacheProperties hussarCacheProperties) {
        this.hussarCacheProperties = hussarCacheProperties;
    }

    @Bean
    public GenericObjectPoolConfig genericObjectPoolConfig(RedisProperties redisProperties) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        if (redisProperties.getLettuce() != null) {
            RedisProperties.Pool properties = redisProperties.getLettuce().getPool();
            config.setMaxTotal(properties.getMaxActive());
            config.setMaxIdle(properties.getMaxIdle());
            config.setMinIdle(properties.getMinIdle());
            if (properties.getTimeBetweenEvictionRuns() != null) {
                config.setTimeBetweenEvictionRuns(properties.getTimeBetweenEvictionRuns());
            }
            if (properties.getMaxWait() != null) {
                config.setMaxWait(properties.getMaxWait());
            }
        }
        return config;
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(value={ClientResources.class})
    public DefaultClientResources lettuceClientResources() {
        DefaultClientResources.Builder builder = DefaultClientResources.builder();
        return builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Bean
    @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
    public LettuceConnectionFactory lettuceConnectionFactory(ClientResources clientResources, RedisProperties redisProperties) {
        LettuceConnectionFactory factory;
        LettuceClientConfiguration clientConfig = this.getLettuceClientConfiguration(clientResources, redisProperties);
        if (this.hussarCacheProperties.getRedisCluster().equalsIgnoreCase(ClusterTypeEnum.CLUSTER.getKey())) {
            if (redisProperties.getCluster() == null) throw new IllegalStateException("redis \u96c6\u7fa4 \u914d\u7f6e\u9519\u8bef\uff01");
            RedisClusterConfiguration redisClusterConfiguration = new RedisClusterConfiguration((Collection)redisProperties.getCluster().getNodes());
            redisClusterConfiguration.setMaxRedirects(redisProperties.getCluster().getMaxRedirects().intValue());
            redisClusterConfiguration.setPassword(redisProperties.getPassword());
            RedisProperties.Cluster clusterProperties = redisProperties.getCluster();
            RedisClusterConfiguration config = new RedisClusterConfiguration((Collection)clusterProperties.getNodes());
            if (clusterProperties.getMaxRedirects() != null) {
                config.setMaxRedirects(clusterProperties.getMaxRedirects().intValue());
            }
            config.setUsername(redisProperties.getUsername());
            if (redisProperties.getPassword() != null) {
                config.setPassword(RedisPassword.of((String)redisProperties.getPassword()));
            }
            factory = new LettuceConnectionFactory(config, clientConfig);
            this.logger.debug("redis \u96c6\u7fa4\u542f\u52a8");
        } else if (this.hussarCacheProperties.getRedisCluster().equals(ClusterTypeEnum.SENTINEL.getKey())) {
            RedisProperties.Sentinel sentinelProperties = redisProperties.getSentinel();
            if (sentinelProperties == null) throw new IllegalStateException("redis \u54e8\u5175 \u914d\u7f6e\u9519\u8bef\uff01");
            RedisSentinelConfiguration config = new RedisSentinelConfiguration();
            config.master(sentinelProperties.getMaster());
            ArrayList<RedisNode> nodes = new ArrayList<RedisNode>();
            for (String node : sentinelProperties.getNodes()) {
                try {
                    nodes.add(RedisNode.fromString((String)node));
                }
                catch (RuntimeException ex) {
                    throw new IllegalStateException("Invalid redis sentinel property '" + node + "'", ex);
                }
            }
            config.setSentinels(nodes);
            config.setUsername(redisProperties.getUsername());
            if (redisProperties.getPassword() != null) {
                config.setPassword(RedisPassword.of((String)redisProperties.getPassword()));
            }
            config.setSentinelUsername(sentinelProperties.getUsername());
            if (sentinelProperties.getPassword() != null) {
                config.setSentinelPassword(RedisPassword.of((String)sentinelProperties.getPassword()));
            }
            config.setDatabase(redisProperties.getDatabase());
            factory = new LettuceConnectionFactory(config, clientConfig);
            this.logger.debug("redis \u54e8\u5175\u542f\u52a8");
        } else {
            RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
            if (StringUtils.hasText((String)redisProperties.getUrl())) {
                ConnectionInfo connectionInfo = this.parseUrl(redisProperties.getUrl());
                config.setHostName(connectionInfo.getHostName());
                config.setPort(connectionInfo.getPort());
                config.setUsername(connectionInfo.getUsername());
                config.setPassword(RedisPassword.of((String)connectionInfo.getPassword()));
            } else {
                config.setHostName(redisProperties.getHost());
                config.setPort(redisProperties.getPort());
                config.setUsername(redisProperties.getUsername());
                config.setPassword(RedisPassword.of((String)redisProperties.getPassword()));
            }
            config.setDatabase(redisProperties.getDatabase());
            factory = new LettuceConnectionFactory(config, clientConfig);
            this.logger.debug("redis \u5355\u673a\u6a21\u5f0f\u8d77\u542f\u52a8");
        }
        factory.setShareNativeConnection(Boolean.FALSE.booleanValue());
        factory.setValidateConnection(Boolean.TRUE.booleanValue());
        return factory;
    }

    private LettuceClientConfiguration getLettuceClientConfiguration(ClientResources clientResources, RedisProperties redisProperties) {
        LettuceClientConfiguration.LettuceClientConfigurationBuilder builder = this.createBuilder(redisProperties.getLettuce().getPool());
        this.applyProperties(builder, redisProperties);
        if (StringUtils.hasText((String)redisProperties.getUrl())) {
            this.customizeConfigurationFromUrl(builder, redisProperties);
        }
        builder.clientOptions(this.createClientOptions(redisProperties));
        builder.clientResources(clientResources);
        return builder.build();
    }

    private LettuceClientConfiguration.LettuceClientConfigurationBuilder applyProperties(LettuceClientConfiguration.LettuceClientConfigurationBuilder builder, RedisProperties redisProperties) {
        RedisProperties.Lettuce lettuce;
        if (redisProperties.isSsl()) {
            builder.useSsl();
        }
        if (redisProperties.getTimeout() != null) {
            builder.commandTimeout(redisProperties.getTimeout());
        }
        if (redisProperties.getLettuce() != null && (lettuce = redisProperties.getLettuce()).getShutdownTimeout() != null && !lettuce.getShutdownTimeout().isZero()) {
            builder.shutdownTimeout(redisProperties.getLettuce().getShutdownTimeout());
        }
        if (StringUtils.hasText((String)redisProperties.getClientName())) {
            builder.clientName(redisProperties.getClientName());
        }
        return builder;
    }

    private ClientOptions createClientOptions(RedisProperties redisProperties) {
        ClientOptions.Builder builder = this.initializeClientOptionsBuilder(redisProperties);
        Duration connectTimeout = redisProperties.getConnectTimeout();
        if (connectTimeout != null) {
            builder.socketOptions(SocketOptions.builder().connectTimeout(connectTimeout).build());
        }
        return builder.timeoutOptions(TimeoutOptions.enabled()).build();
    }

    private ClientOptions.Builder initializeClientOptionsBuilder(RedisProperties redisProperties) {
        if (redisProperties.getCluster() != null) {
            ClusterClientOptions.Builder builder = ClusterClientOptions.builder();
            RedisProperties.Lettuce.Cluster.Refresh refreshProperties = redisProperties.getLettuce().getCluster().getRefresh();
            ClusterTopologyRefreshOptions.Builder refreshBuilder = ClusterTopologyRefreshOptions.builder().dynamicRefreshSources(refreshProperties.isDynamicRefreshSources());
            if (refreshProperties.getPeriod() != null) {
                refreshBuilder.enablePeriodicRefresh(refreshProperties.getPeriod());
            }
            if (refreshProperties.isAdaptive()) {
                refreshBuilder.enableAllAdaptiveRefreshTriggers();
            }
            return builder.topologyRefreshOptions(refreshBuilder.build());
        }
        return ClientOptions.builder();
    }

    private void customizeConfigurationFromUrl(LettuceClientConfiguration.LettuceClientConfigurationBuilder builder, RedisProperties redisProperties) {
        ConnectionInfo connectionInfo = this.parseUrl(redisProperties.getUrl());
        if (connectionInfo.isUseSsl()) {
            builder.useSsl();
        }
    }

    protected boolean isPoolEnabled(RedisProperties.Pool pool) {
        Boolean enabled = pool.getEnabled();
        return enabled != null ? enabled : COMMONS_POOL2_AVAILABLE;
    }

    private LettuceClientConfiguration.LettuceClientConfigurationBuilder createBuilder(RedisProperties.Pool pool) {
        if (this.isPoolEnabled(pool)) {
            return new PoolBuilderFactory().createBuilder(pool);
        }
        return LettuceClientConfiguration.builder();
    }

    protected ConnectionInfo parseUrl(String url) {
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            if (!"redis".equals(scheme) && !"rediss".equals(scheme)) {
                throw new HussarRedisUrlSyntaxException(url);
            }
            boolean useSsl = "rediss".equals(scheme);
            String username = null;
            String password = null;
            if (uri.getUserInfo() != null) {
                String candidate = uri.getUserInfo();
                int index = candidate.indexOf(58);
                if (index >= 0) {
                    username = candidate.substring(0, index);
                    password = candidate.substring(index + 1);
                } else {
                    password = candidate;
                }
            }
            return new ConnectionInfo(uri, useSsl, username, password);
        }
        catch (URISyntaxException ex) {
            throw new HussarRedisUrlSyntaxException(url, ex);
        }
    }

    @Bean
    public RedisSerializer<String> stringRedisSerializer() {
        return HussarRedisAutoConfiguration.getStringRedisSerializer();
    }

    @Bean
    public RedisSerializer jackson2JsonRedisSerializer() {
        return HussarRedisAutoConfiguration.getJackson2JsonRedisSerializer();
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisTemplate"})
    public RedisTemplate<Object, Object> redisTemplate(LettuceConnectionFactory lettuceConnectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)lettuceConnectionFactory);
        template.setKeySerializer(this.jackson2JsonRedisSerializer());
        template.setHashKeySerializer(this.jackson2JsonRedisSerializer());
        template.setValueSerializer(this.jackson2JsonRedisSerializer());
        template.setHashValueSerializer(this.jackson2JsonRedisSerializer());
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(name={"stringRedisTemplate"})
    public StringRedisTemplate stringRedisTemplate(LettuceConnectionFactory lettuceConnectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)lettuceConnectionFactory);
        template.setKeySerializer(this.stringRedisSerializer());
        template.setHashKeySerializer(this.stringRedisSerializer());
        template.setValueSerializer(this.jackson2JsonRedisSerializer());
        template.setHashValueSerializer(this.jackson2JsonRedisSerializer());
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    public HussarSpringRedisCacheWriter hussarSpringRedisCacheWriter(LettuceConnectionFactory lettuceConnectionFactory) {
        return new HussarSpringRedisCacheWriter((RedisConnectionFactory)lettuceConnectionFactory);
    }

    @Primary
    @Bean
    @ConditionalOnProperty(prefix="hussar.cache.multi-level", name={"enable"}, havingValue="false", matchIfMissing=true)
    public HussarSpringRedisCacheManger cacheManager(HussarSpringRedisCacheWriter hussarSpringRedisCacheWriter, HussarTenantProperties hussarTenantProperties, HussarSecurityProperties hussarSecurityProperties, HussarCacheProperties hussarCacheProperties, CacheNameCreator cacheNameCreator) {
        return HussarRedisAutoConfiguration.getHussarSpringRedisCacheManger(hussarSpringRedisCacheWriter, hussarTenantProperties, hussarSecurityProperties, hussarCacheProperties, cacheNameCreator);
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheNameCreator cacheNameCreator() {
        return new DefaultCacheNameCreator();
    }

    public HussarCacheProperties getHussarRedisProperties() {
        return this.hussarCacheProperties;
    }

    public void setHussarRedisProperties(HussarCacheProperties hussarCacheProperties) {
        this.hussarCacheProperties = hussarCacheProperties;
    }

    public static HussarSpringRedisCacheManger getHussarSpringRedisCacheManger(HussarSpringRedisCacheWriter hussarSpringRedisCacheWriter, HussarTenantProperties hussarTenantProperties, HussarSecurityProperties hussarSecurityProperties, HussarCacheProperties hussarCacheProperties, CacheNameCreator cacheNameCreator) {
        RedisCacheConfiguration defaultCacheConfig = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ZERO).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer(HussarRedisAutoConfiguration.getStringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)HussarRedisAutoConfiguration.getJackson2JsonRedisSerializer())).disableCachingNullValues();
        HussarSpringRedisCacheManger hussarSpringRedisCacheManger = HussarSpringRedisCacheManger.builder(hussarSpringRedisCacheWriter).cacheDefaults(defaultCacheConfig).build();
        List<String> noControlCacheName = hussarCacheProperties.getNoControlCacheName();
        if (HussarUtils.isEmpty(noControlCacheName)) {
            noControlCacheName = new ArrayList<String>();
            noControlCacheName.add(hussarSecurityProperties.getTokenName());
        } else if (!noControlCacheName.contains(hussarSecurityProperties.getTokenName())) {
            noControlCacheName.add(hussarSecurityProperties.getTokenName());
        }
        hussarCacheProperties.setNoControlCacheName(noControlCacheName);
        hussarSpringRedisCacheManger.setHussarCacheProperties(hussarCacheProperties);
        hussarSpringRedisCacheManger.setCacheNameCreator(cacheNameCreator);
        hussarSpringRedisCacheManger.setHussarTenantProperties(hussarTenantProperties);
        return hussarSpringRedisCacheManger;
    }

    public static RedisSerializer<String> getStringRedisSerializer() {
        return new StringRedisSerializer();
    }

    public static RedisSerializer getJackson2JsonRedisSerializer() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        mapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new JavaTimeModule());
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        jackson2JsonRedisSerializer.setObjectMapper(mapper);
        return jackson2JsonRedisSerializer;
    }
}

