/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.support.HussarCache;
import com.jxdinfo.hussar.support.cache.support.NoCacheManagerException;
import com.jxdinfo.hussar.support.cache.util.AbstractHussarCacheOperator;
import java.time.Duration;
import java.util.List;
import org.springframework.cache.Cache;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class HussarFixedCacheUtil
extends AbstractHussarCacheOperator {
    protected static HussarCache getCache(String cacheName) {
        if (StringUtils.isEmpty((Object)cacheName)) {
            throw new NoCacheManagerException("\u7f13\u5b58\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return (HussarCache)HussarFixedCacheUtil.getHussarCacheManager().getCache(StringUtil.addPrefixIfNot((CharSequence)cacheName, (CharSequence)"fixed_cache_name_prefix::"));
    }

    public static void put(String cacheName, Object key, @Nullable Object value) {
        Long keyExpireTime = HussarFixedCacheUtil.getCache(cacheName).getKeyExpireTime(key);
        if (HussarUtils.isEmpty((Object)keyExpireTime)) {
            HussarFixedCacheUtil.getCache(cacheName).put(key, value, Duration.ZERO);
        } else {
            HussarFixedCacheUtil.getCache(cacheName).put(key, value, keyExpireTime);
        }
    }

    public static void put(String cacheName, Object key, Object value, long seconds) {
        HussarFixedCacheUtil.getCache(cacheName).put(key, value, seconds);
    }

    public static <T> T putIfAbsent(String cacheName, Object key, @Nullable T value) {
        Cache.ValueWrapper valueWrapper = HussarFixedCacheUtil.getCache(cacheName).putIfAbsent(key, value);
        if (valueWrapper == null) {
            return value;
        }
        return (T)valueWrapper.get();
    }

    public static <T> T putIfAbsent(String cacheName, Object key, @Nullable T value, long seconds) {
        Cache.ValueWrapper valueWrapper = HussarFixedCacheUtil.getCache(cacheName).putIfAbsent(key, value, seconds);
        if (valueWrapper == null) {
            return value;
        }
        return (T)valueWrapper.get();
    }

    public static <T> T get(String cacheName, Object key, @Nullable Class<T> type) {
        Object t = null;
        try {
            t = HussarFixedCacheUtil.getCache(cacheName).get(key, type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    public static <T> T get(String cacheName, Object key) {
        Cache.ValueWrapper valueWrapper = HussarFixedCacheUtil.getCache(cacheName).get(key);
        if (valueWrapper == null) {
            return null;
        }
        return (T)valueWrapper.get();
    }

    public static boolean containKey(String cacheName, Object key) {
        if (StringUtils.isEmpty((Object)key)) {
            return false;
        }
        return HussarFixedCacheUtil.getCache(cacheName).containKey(key);
    }

    public static List<String> getKeysLeftLike(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        key = "*" + key;
        return HussarFixedCacheUtil.getCache(cacheName).getKeys(key);
    }

    public static List<String> getKeysRightLike(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        key = key + "*";
        return HussarFixedCacheUtil.getCache(cacheName).getKeys(key);
    }

    public static List<String> getKeysLike(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        key = "*" + key + "*";
        return HussarFixedCacheUtil.getCache(cacheName).getKeys(key);
    }

    public static List<String> getKeys(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        return HussarFixedCacheUtil.getCache(cacheName).getKeys(key);
    }

    public static List<String> scanKeys(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        return HussarFixedCacheUtil.getCache(cacheName).scanKeys(key);
    }

    public static void evict(String cacheName, Object key) {
        HussarFixedCacheUtil.getCache(cacheName).evict(key);
    }

    public static void evictKeysLike(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return;
        }
        key = "*" + key + "*";
        HussarFixedCacheUtil.getCache(cacheName).evictKeys(key);
    }

    public static void evictKeysLeftLike(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return;
        }
        key = "*" + key;
        HussarFixedCacheUtil.getCache(cacheName).evictKeys(key);
    }

    public static void evictKeysRightLike(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return;
        }
        key = key + "*";
        HussarFixedCacheUtil.getCache(cacheName).evictKeys(key);
    }

    public static Long getKeyExpireTime(String cacheName, String key) {
        return HussarFixedCacheUtil.getCache(cacheName).getKeyExpireTime(key);
    }
}

