/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.properties;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.support.redis.ClusterTypeEnum;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="hussar.cache")
public class HussarCacheProperties {
    private String redisCluster = ClusterTypeEnum.STANDALONE.getKey();
    private String cacheType = "ehcache";
    private List<String> noControlCacheName = new ArrayList<String>();
    private static final Set<String> defaultNoControlCacheName = new HashSet<String>();

    public String getRedisCluster() {
        return this.redisCluster;
    }

    public void setRedisCluster(String redisCluster) {
        this.redisCluster = redisCluster;
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(String cacheType) {
        this.cacheType = cacheType;
    }

    public List<String> getNoControlCacheName() {
        ArrayList<String> allNoControlCacheNameList = new ArrayList<String>(defaultNoControlCacheName);
        if (HussarUtils.isNotEmpty(this.noControlCacheName)) {
            allNoControlCacheNameList.addAll(this.noControlCacheName);
        }
        return allNoControlCacheNameList;
    }

    public void setNoControlCacheName(List<String> noControlCacheName) {
        this.noControlCacheName = noControlCacheName;
    }

    static {
        defaultNoControlCacheName.add("hussar_base_security_client_cache");
    }
}

