/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support;

import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.support.cache.support.CacheNameCreator;
import com.jxdinfo.hussar.support.cache.support.HussarCache;
import com.jxdinfo.hussar.support.cache.support.HussarCacheManager;
import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class HussarAbstractCacheManager
implements HussarCacheManager {
    private static final ConcurrentMap<String, HussarCache> CACHE_MAP = new ConcurrentHashMap<String, HussarCache>();
    private HussarTenantProperties hussarTenantProperties;
    private HussarCacheProperties hussarCacheProperties;
    private CacheNameCreator cacheNameCreator;

    public HussarAbstractCacheManager() {
    }

    public HussarAbstractCacheManager(HussarTenantProperties hussarTenantProperties) {
        this.hussarTenantProperties = hussarTenantProperties;
    }

    public HussarAbstractCacheManager(HussarCacheProperties hussarCacheProperties) {
        this.hussarCacheProperties = hussarCacheProperties;
    }

    public HussarTenantProperties getHussarTenantProperties() {
        return this.hussarTenantProperties;
    }

    public void setHussarTenantProperties(HussarTenantProperties hussarTenantProperties) {
        this.hussarTenantProperties = hussarTenantProperties;
    }

    public CacheNameCreator getCacheNameCreator() {
        return this.cacheNameCreator;
    }

    public void setCacheNameCreator(CacheNameCreator cacheNameCreator) {
        this.cacheNameCreator = cacheNameCreator;
    }

    public HussarCacheProperties getHussarCacheProperties() {
        return this.hussarCacheProperties;
    }

    public void setHussarCacheProperties(HussarCacheProperties hussarCacheProperties) {
        this.hussarCacheProperties = hussarCacheProperties;
    }

    @Override
    public HussarCache getCache(String cacheName) {
        HussarCache cache;
        if (this.hussarTenantProperties.isEnabled()) {
            cacheName = this.cacheNameCreator.creatCacheName(cacheName, this.hussarCacheProperties);
        }
        if ((cache = (HussarCache)CACHE_MAP.get(cacheName)) == null) {
            cache = this.getMissingCache(cacheName);
            CACHE_MAP.putIfAbsent(cacheName, cache);
        }
        return cache;
    }
}

