/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support;

import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.support.CacheNameCreator;
import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.lang.Nullable;

public abstract class SpringAbstractCacheManager
implements CacheManager,
InitializingBean {
    private final ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>(16);
    private volatile Set<String> cacheNames = Collections.emptySet();
    private HussarTenantProperties hussarTenantProperties;
    private HussarCacheProperties hussarCacheProperties;
    private CacheNameCreator cacheNameCreator;

    public void afterPropertiesSet() {
        this.initializeCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeCaches() {
        Collection<? extends Cache> caches = this.loadCaches();
        ConcurrentMap<String, Cache> concurrentMap = this.cacheMap;
        synchronized (concurrentMap) {
            this.cacheNames = Collections.emptySet();
            this.cacheMap.clear();
            LinkedHashSet<String> cacheNames = new LinkedHashSet<String>(caches.size());
            for (Cache cache : caches) {
                String name = cache.getName();
                this.cacheMap.put(name, this.decorateCache(cache));
                cacheNames.add(name);
            }
            this.cacheNames = Collections.unmodifiableSet(cacheNames);
        }
    }

    protected abstract Collection<? extends Cache> loadCaches();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Cache getCache(String name) {
        Cache cache;
        boolean isFixed = StringUtil.startWith((CharSequence)name, (CharSequence)"fixed_cache_name_prefix::");
        if (this.isDoHandlerCacheName(name) && !isFixed) {
            name = this.cacheNameCreator.creatCacheName(name, this.hussarCacheProperties);
        }
        if (isFixed) {
            name = StringUtil.removePrefix((CharSequence)name, (CharSequence)"fixed_cache_name_prefix::");
        }
        if ((cache = (Cache)this.cacheMap.get(name)) != null) {
            return cache;
        }
        Cache missingCache = this.getMissingCache(name);
        if (missingCache != null) {
            ConcurrentMap<String, Cache> concurrentMap = this.cacheMap;
            synchronized (concurrentMap) {
                cache = (Cache)this.cacheMap.get(name);
                if (cache == null) {
                    cache = this.decorateCache(missingCache);
                    this.cacheMap.put(name, cache);
                    this.updateCacheNames(name);
                }
            }
        }
        return cache;
    }

    public Collection<String> getCacheNames() {
        return this.cacheNames;
    }

    @Nullable
    protected final Cache lookupCache(String name) {
        return (Cache)this.cacheMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected final void addCache(Cache cache) {
        String name = cache.getName();
        ConcurrentMap<String, Cache> concurrentMap = this.cacheMap;
        synchronized (concurrentMap) {
            if (this.cacheMap.put(name, this.decorateCache(cache)) == null) {
                this.updateCacheNames(name);
            }
        }
    }

    private void updateCacheNames(String name) {
        LinkedHashSet<String> cacheNames = new LinkedHashSet<String>(this.cacheNames.size() + 1);
        cacheNames.addAll(this.cacheNames);
        cacheNames.add(name);
        this.cacheNames = Collections.unmodifiableSet(cacheNames);
    }

    private boolean isDoHandlerCacheName(String cacheName) {
        if (!this.hussarTenantProperties.isEnabled()) {
            return false;
        }
        boolean flag = false;
        List<String> noControlCacheName = this.hussarCacheProperties.getNoControlCacheName();
        if (HussarUtils.isEmpty(noControlCacheName)) {
            flag = true;
        } else if (!noControlCacheName.contains(cacheName)) {
            flag = true;
        }
        return flag;
    }

    protected Cache decorateCache(Cache cache) {
        return cache;
    }

    @Nullable
    protected Cache getMissingCache(String name) {
        return null;
    }

    public HussarTenantProperties getHussarTenantProperties() {
        return this.hussarTenantProperties;
    }

    public void setHussarTenantProperties(HussarTenantProperties hussarTenantProperties) {
        this.hussarTenantProperties = hussarTenantProperties;
    }

    public HussarCacheProperties getHussarCacheProperties() {
        return this.hussarCacheProperties;
    }

    public void setHussarCacheProperties(HussarCacheProperties hussarCacheProperties) {
        this.hussarCacheProperties = hussarCacheProperties;
    }

    public CacheNameCreator getCacheNameCreator() {
        return this.cacheNameCreator;
    }

    public void setCacheNameCreator(CacheNameCreator cacheNameCreator) {
        this.cacheNameCreator = cacheNameCreator;
    }
}

