/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.config;

import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.support.CacheNameCreator;
import com.jxdinfo.hussar.support.cache.support.ehcache.SpringEhCacheCacheManager;
import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import com.jxdinfo.hussar.support.cache.support.properties.HussarSecurityProperties;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Configuration
public class FixLocalCacheConfiguration {
    @Bean
    public EhCacheManagerFactoryBean jobLocalCacheManagerFactory() {
        ClassPathResource resource = new ClassPathResource("ehcache.xml");
        EhCacheManagerFactoryBean ehCacheManagerFactoryBean = new EhCacheManagerFactoryBean();
        ehCacheManagerFactoryBean.setConfigLocation((Resource)resource);
        return ehCacheManagerFactoryBean;
    }

    @Bean
    public SpringEhCacheCacheManager jobLocalCacheManager(HussarTenantProperties hussarTenantProperties, HussarSecurityProperties hussarSecurityProperties, HussarCacheProperties hussarCacheProperties, CacheNameCreator cacheNameCreator, EhCacheManagerFactoryBean jobLocalCacheManagerFactory) {
        SpringEhCacheCacheManager ehCacheCacheManager = new SpringEhCacheCacheManager();
        ehCacheCacheManager.setCacheManager(jobLocalCacheManagerFactory.getObject());
        List<String> noControlCacheName = hussarCacheProperties.getNoControlCacheName();
        if (HussarUtils.isEmpty(noControlCacheName)) {
            noControlCacheName = new ArrayList<String>();
            noControlCacheName.add(hussarSecurityProperties.getTokenName());
        } else if (!noControlCacheName.contains(hussarSecurityProperties.getTokenName())) {
            noControlCacheName.add(hussarSecurityProperties.getTokenName());
        }
        hussarCacheProperties.setNoControlCacheName(noControlCacheName);
        ehCacheCacheManager.setHussarCacheProperties(hussarCacheProperties);
        ehCacheCacheManager.setCacheNameCreator(cacheNameCreator);
        ehCacheCacheManager.setHussarTenantProperties(hussarTenantProperties);
        return ehCacheCacheManager;
    }
}

